/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.ogm.util.impl;

import java.beans.Introspector;
import java.lang.annotation.ElementType;
import java.lang.reflect.Field;
import java.lang.reflect.Method;

public final class ReflectionHelper {
    private static final String PROPERTY_ACCESSOR_PREFIX_GET = "get";
    private static final String PROPERTY_ACCESSOR_PREFIX_IS = "is";

    public static boolean propertyExists(Class<?> clazz, String property, ElementType elementType) {
        if (ElementType.FIELD.equals((Object)elementType)) {
            return ReflectionHelper.getDeclaredField(clazz, property) != null;
        }
        String capitalizedPropertyName = ReflectionHelper.capitalize(property);
        Method method = ReflectionHelper.getMethod(clazz, PROPERTY_ACCESSOR_PREFIX_GET + capitalizedPropertyName, new Class[0]);
        if (method != null && method.getReturnType() != Void.TYPE) {
            return true;
        }
        method = ReflectionHelper.getMethod(clazz, PROPERTY_ACCESSOR_PREFIX_IS + capitalizedPropertyName, new Class[0]);
        return method != null && method.getReturnType() == Boolean.TYPE;
    }

    public static String getPropertyName(Method method) {
        if (method.getParameterTypes().length == 0) {
            String methodName = method.getName();
            if (methodName.startsWith(PROPERTY_ACCESSOR_PREFIX_GET) && method.getReturnType() != Void.TYPE) {
                return Introspector.decapitalize(methodName.substring(3));
            }
            if (methodName.startsWith(PROPERTY_ACCESSOR_PREFIX_IS) && method.getReturnType() == Boolean.TYPE) {
                return Introspector.decapitalize(methodName.substring(2));
            }
        }
        return null;
    }

    private static Field getDeclaredField(Class<?> clazz, String fieldName) {
        try {
            Field field = clazz.getDeclaredField(fieldName);
            field.setAccessible(true);
            return field;
        }
        catch (NoSuchFieldException e) {
            return null;
        }
    }

    private static Method getMethod(Class<?> clazz, String methodName, Class<?> ... parameterTypes) {
        try {
            return clazz.getMethod(methodName, parameterTypes);
        }
        catch (NoSuchMethodException e) {
            return null;
        }
    }

    private static String capitalize(String property) {
        return property.substring(0, 1).toUpperCase() + property.substring(1);
    }
}

