/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.ogm.datastore.neo4j.dialect.impl;

import java.util.Map;
import org.hibernate.ogm.datastore.neo4j.dialect.impl.NodeLabel;
import org.hibernate.ogm.datastore.neo4j.dialect.impl.QueriesBase;
import org.hibernate.ogm.model.key.spi.EntityKeyMetadata;
import org.neo4j.cypher.javacompat.ExecutionEngine;
import org.neo4j.cypher.javacompat.ExecutionResult;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.ResourceIterator;

public class Neo4jEntityQueries
extends QueriesBase {
    private final String createEmbeddedNodeQuery;
    private final String findEntityQuery;
    private final String findEntitiesQuery;
    private final String findOrCreateEntityQuery;
    private final String removeEntityQuery;

    public Neo4jEntityQueries(EntityKeyMetadata entityKeyMetadata) {
        this.createEmbeddedNodeQuery = Neo4jEntityQueries.initCreateEmbeddedNodeQuery(entityKeyMetadata);
        this.findEntityQuery = Neo4jEntityQueries.initFindEntityQuery(entityKeyMetadata);
        this.findEntitiesQuery = Neo4jEntityQueries.initFindEntitiesQuery(entityKeyMetadata);
        this.findOrCreateEntityQuery = Neo4jEntityQueries.initFindOrCreateEntityQuery(entityKeyMetadata);
        this.removeEntityQuery = Neo4jEntityQueries.initRemoveEntityQuery(entityKeyMetadata);
    }

    private static String initCreateEmbeddedNodeQuery(EntityKeyMetadata entityKeyMetadata) {
        StringBuilder queryBuilder = new StringBuilder("CREATE ");
        queryBuilder.append("(n:");
        queryBuilder.append((Object)NodeLabel.EMBEDDED);
        queryBuilder.append(":");
        Neo4jEntityQueries.appendLabel(entityKeyMetadata, queryBuilder);
        Neo4jEntityQueries.appendProperties(entityKeyMetadata, queryBuilder);
        queryBuilder.append(")");
        queryBuilder.append(" RETURN n");
        return queryBuilder.toString();
    }

    private static String initFindEntityQuery(EntityKeyMetadata entityKeyMetadata) {
        StringBuilder queryBuilder = new StringBuilder("MATCH ");
        queryBuilder.append("(n:");
        queryBuilder.append((Object)NodeLabel.ENTITY);
        queryBuilder.append(":");
        Neo4jEntityQueries.appendLabel(entityKeyMetadata, queryBuilder);
        Neo4jEntityQueries.appendProperties(entityKeyMetadata, queryBuilder);
        queryBuilder.append(")");
        queryBuilder.append(" RETURN n");
        return queryBuilder.toString();
    }

    private static String initFindEntitiesQuery(EntityKeyMetadata entityKeyMetadata) {
        StringBuilder queryBuilder = new StringBuilder("MATCH ");
        queryBuilder.append("(n:");
        queryBuilder.append((Object)NodeLabel.ENTITY);
        queryBuilder.append(":");
        Neo4jEntityQueries.appendLabel(entityKeyMetadata, queryBuilder);
        queryBuilder.append(") RETURN n");
        return queryBuilder.toString();
    }

    private static String initFindOrCreateEntityQuery(EntityKeyMetadata entityKeyMetadata) {
        StringBuilder queryBuilder = new StringBuilder("MERGE ");
        queryBuilder.append("(n:");
        queryBuilder.append((Object)NodeLabel.ENTITY);
        queryBuilder.append(":");
        Neo4jEntityQueries.appendLabel(entityKeyMetadata, queryBuilder);
        Neo4jEntityQueries.appendProperties(entityKeyMetadata, queryBuilder);
        queryBuilder.append(")");
        queryBuilder.append(" RETURN n");
        return queryBuilder.toString();
    }

    private static String initRemoveEntityQuery(EntityKeyMetadata entityKeyMetadata) {
        StringBuilder queryBuilder = new StringBuilder("MATCH ");
        queryBuilder.append("(n:");
        queryBuilder.append((Object)NodeLabel.ENTITY);
        queryBuilder.append(":");
        Neo4jEntityQueries.appendLabel(entityKeyMetadata, queryBuilder);
        Neo4jEntityQueries.appendProperties(entityKeyMetadata, queryBuilder);
        queryBuilder.append(")");
        queryBuilder.append(" OPTIONAL MATCH (n) - [r] - ()");
        queryBuilder.append(" DELETE n, r");
        return queryBuilder.toString();
    }

    public Node createEmbedded(ExecutionEngine executionEngine, Object[] columnValues) {
        Map<String, Object> params = this.params(columnValues);
        ExecutionResult result = executionEngine.execute(this.createEmbeddedNodeQuery, params);
        return (Node)this.singleResult(result);
    }

    public Node findEntity(ExecutionEngine executionEngine, Object[] columnValues) {
        Map<String, Object> params = this.params(columnValues);
        ExecutionResult result = executionEngine.execute(this.findEntityQuery, params);
        return (Node)this.singleResult(result);
    }

    public Node findOrCreateEntity(ExecutionEngine executionEngine, Object[] columnValues) {
        Map<String, Object> params = this.params(columnValues);
        ExecutionResult result = executionEngine.execute(this.findOrCreateEntityQuery, params);
        return (Node)this.singleResult(result);
    }

    public ResourceIterator<Node> findEntities(ExecutionEngine executionEngine) {
        ExecutionResult result = executionEngine.execute(this.findEntitiesQuery);
        return result.columnAs("n");
    }

    public void removeEntity(ExecutionEngine executionEngine, Object[] columnValues) {
        Map<String, Object> params = this.params(columnValues);
        executionEngine.execute(this.removeEntityQuery, params);
    }
}

