/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.ogm.datastore.neo4j.dialect.impl;

import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.hibernate.ogm.model.key.spi.AssociatedEntityKeyMetadata;
import org.hibernate.ogm.model.spi.TupleSnapshot;
import org.neo4j.graphdb.Direction;
import org.neo4j.graphdb.DynamicRelationshipType;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.Relationship;
import org.neo4j.graphdb.RelationshipType;

public final class Neo4jTupleSnapshot
implements TupleSnapshot {
    private final Node node;
    private final Map<String, AssociatedEntityKeyMetadata> associatedEntityKeyMetadata;
    private final Map<String, String> rolesByColumn;

    public Neo4jTupleSnapshot(Node node) {
        this(node, Collections.emptyMap(), Collections.emptyMap());
    }

    public Neo4jTupleSnapshot(Node node, Map<String, AssociatedEntityKeyMetadata> associatedEntityKeyMetadata, Map<String, String> rolesByColumn) {
        this.node = node;
        this.associatedEntityKeyMetadata = associatedEntityKeyMetadata;
        this.rolesByColumn = rolesByColumn;
    }

    public Object get(String column) {
        if (this.associatedEntityKeyMetadata.containsKey(column)) {
            return this.readPropertyOnOtherNode(column);
        }
        return this.readProperty(this.node, column);
    }

    private Object readPropertyOnOtherNode(String column) {
        Iterator relationships = this.node.getRelationships(Direction.OUTGOING, new RelationshipType[]{DynamicRelationshipType.withName((String)this.rolesByColumn.get(column))}).iterator();
        if (relationships.hasNext()) {
            Node otherNode = ((Relationship)relationships.next()).getEndNode();
            return this.readProperty(otherNode, this.associatedEntityKeyMetadata.get(column).getCorrespondingEntityKeyColumn(column));
        }
        return null;
    }

    private Object readProperty(Node otherNode, String targetColumnName) {
        Object value = null;
        if (otherNode.hasProperty(targetColumnName)) {
            value = otherNode.getProperty(targetColumnName);
        }
        return value;
    }

    public boolean isEmpty() {
        return !this.node.getPropertyKeys().iterator().hasNext();
    }

    public Set<String> getColumnNames() {
        HashSet<String> names = new HashSet<String>();
        for (String string : this.node.getPropertyKeys()) {
            names.add(string);
        }
        return names;
    }

    public Node getNode() {
        return this.node;
    }
}

