/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.collection.primitive.hopscotch;

import org.neo4j.collection.primitive.PrimitiveIntIterator;
import org.neo4j.collection.primitive.PrimitiveIntSet;
import org.neo4j.collection.primitive.hopscotch.AbstractIntHopScotchCollection;
import org.neo4j.collection.primitive.hopscotch.HopScotchHashingAlgorithm;
import org.neo4j.collection.primitive.hopscotch.Table;

public class PrimitiveIntHashSet
extends AbstractIntHopScotchCollection<Object>
implements PrimitiveIntSet {
    private final Object valueMarker;
    private final HopScotchHashingAlgorithm.Monitor monitor;

    public PrimitiveIntHashSet(Table<Object> table, Object valueMarker, HopScotchHashingAlgorithm.Monitor monitor) {
        super(table);
        this.valueMarker = valueMarker;
        this.monitor = monitor;
    }

    @Override
    public boolean add(int value) {
        return HopScotchHashingAlgorithm.put(this.table, this.monitor, HopScotchHashingAlgorithm.DEFAULT_HASHING, value, this.valueMarker, this) == null;
    }

    @Override
    public boolean addAll(PrimitiveIntIterator values) {
        boolean changed = false;
        while (values.hasNext()) {
            changed |= HopScotchHashingAlgorithm.put(this.table, this.monitor, HopScotchHashingAlgorithm.DEFAULT_HASHING, values.next(), this.valueMarker, this) == null;
        }
        return changed;
    }

    @Override
    public boolean contains(int value) {
        return HopScotchHashingAlgorithm.get(this.table, this.monitor, HopScotchHashingAlgorithm.DEFAULT_HASHING, value) == this.valueMarker;
    }

    @Override
    public boolean remove(int value) {
        return HopScotchHashingAlgorithm.remove(this.table, this.monitor, HopScotchHashingAlgorithm.DEFAULT_HASHING, value) == this.valueMarker;
    }
}

