/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.resteasy.skeleton.key.config;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.security.KeyStore;
import java.security.PublicKey;
import org.codehaus.jackson.map.ObjectMapper;
import org.codehaus.jackson.map.annotate.JsonSerialize;
import org.jboss.resteasy.skeleton.key.EnvUtil;
import org.jboss.resteasy.skeleton.key.PemUtils;
import org.jboss.resteasy.skeleton.key.ResourceMetadata;
import org.jboss.resteasy.skeleton.key.config.ManagedResourceConfig;

public class ManagedResourceConfigLoader {
    protected ManagedResourceConfig remoteSkeletonKeyConfig;
    protected ResourceMetadata resourceMetadata;

    public static KeyStore loadKeyStore(String filename, String password) throws Exception {
        KeyStore trustStore = KeyStore.getInstance(KeyStore.getDefaultType());
        File truststoreFile = new File(filename);
        FileInputStream trustStream = new FileInputStream(truststoreFile);
        trustStore.load(trustStream, password.toCharArray());
        trustStream.close();
        return trustStore;
    }

    protected void init(InputStream is) {
        ObjectMapper mapper = new ObjectMapper();
        mapper.setSerializationInclusion(JsonSerialize.Inclusion.NON_DEFAULT);
        this.remoteSkeletonKeyConfig = null;
        try {
            this.remoteSkeletonKeyConfig = (ManagedResourceConfig)mapper.readValue(is, ManagedResourceConfig.class);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        String name = this.remoteSkeletonKeyConfig.getResource();
        String realm = this.remoteSkeletonKeyConfig.getRealm();
        if (realm == null) {
            throw new RuntimeException("Must set 'realm' in config");
        }
        String realmKeyPem = this.remoteSkeletonKeyConfig.getRealmKey();
        if (realmKeyPem == null) {
            throw new IllegalArgumentException("You must set the realm-public-key");
        }
        PublicKey realmKey = null;
        try {
            realmKey = PemUtils.decodePublicKey(realmKeyPem);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        this.resourceMetadata = new ResourceMetadata();
        this.resourceMetadata.setRealm(realm);
        this.resourceMetadata.setResourceName(name);
        this.resourceMetadata.setRealmKey(realmKey);
        String truststore = this.remoteSkeletonKeyConfig.getTruststore();
        if (truststore != null) {
            truststore = EnvUtil.replace(truststore);
            String truststorePassword = this.remoteSkeletonKeyConfig.getTruststorePassword();
            KeyStore trust = null;
            try {
                trust = ManagedResourceConfigLoader.loadKeyStore(truststore, truststorePassword);
            }
            catch (Exception e) {
                throw new RuntimeException("Failed to load truststore", e);
            }
            this.resourceMetadata.setTruststore(trust);
        }
        String clientKeystore = this.remoteSkeletonKeyConfig.getClientKeystore();
        String clientKeyPassword = null;
        if (clientKeystore != null) {
            clientKeystore = EnvUtil.replace(clientKeystore);
            String clientKeystorePassword = this.remoteSkeletonKeyConfig.getClientKeystorePassword();
            KeyStore serverKS = null;
            try {
                serverKS = ManagedResourceConfigLoader.loadKeyStore(clientKeystore, clientKeystorePassword);
            }
            catch (Exception e) {
                throw new RuntimeException("Failed to load keystore", e);
            }
            this.resourceMetadata.setClientKeystore(serverKS);
            clientKeyPassword = this.remoteSkeletonKeyConfig.getClientKeyPassword();
            this.resourceMetadata.setClientKeyPassword(clientKeyPassword);
        }
    }

    public ManagedResourceConfig getRemoteSkeletonKeyConfig() {
        return this.remoteSkeletonKeyConfig;
    }

    public ResourceMetadata getResourceMetadata() {
        return this.resourceMetadata;
    }
}

