/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.ogm.loader.impl;

import java.io.Serializable;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import org.hibernate.HibernateException;
import org.hibernate.LockMode;
import org.hibernate.LockOptions;
import org.hibernate.WrongClassException;
import org.hibernate.annotations.common.AssertionFailure;
import org.hibernate.cfg.NotYetImplementedException;
import org.hibernate.collection.spi.PersistentCollection;
import org.hibernate.engine.internal.TwoPhaseLoad;
import org.hibernate.engine.spi.EntityUniqueKey;
import org.hibernate.engine.spi.PersistenceContext;
import org.hibernate.engine.spi.QueryParameters;
import org.hibernate.engine.spi.SessionFactoryImplementor;
import org.hibernate.engine.spi.SessionImplementor;
import org.hibernate.event.spi.EventSource;
import org.hibernate.event.spi.PreLoadEvent;
import org.hibernate.internal.util.collections.ArrayHelper;
import org.hibernate.loader.CollectionAliases;
import org.hibernate.loader.entity.UniqueEntityLoader;
import org.hibernate.ogm.dialect.spi.GridDialect;
import org.hibernate.ogm.entityentry.impl.OgmEntityEntryState;
import org.hibernate.ogm.jdbc.impl.TupleAsMapResultSet;
import org.hibernate.ogm.loader.impl.OgmColumnCollectionAliases;
import org.hibernate.ogm.loader.impl.OgmLoadingContext;
import org.hibernate.ogm.model.impl.EntityKeyBuilder;
import org.hibernate.ogm.model.key.spi.EntityKey;
import org.hibernate.ogm.model.key.spi.RowKey;
import org.hibernate.ogm.model.spi.Association;
import org.hibernate.ogm.model.spi.Tuple;
import org.hibernate.ogm.persister.impl.OgmCollectionPersister;
import org.hibernate.ogm.persister.impl.OgmEntityPersister;
import org.hibernate.ogm.type.spi.GridType;
import org.hibernate.ogm.util.impl.AssociationPersister;
import org.hibernate.ogm.util.impl.Log;
import org.hibernate.ogm.util.impl.LoggerFactory;
import org.hibernate.ogm.util.impl.StringHelper;
import org.hibernate.persister.collection.CollectionPersister;
import org.hibernate.persister.entity.EntityPersister;
import org.hibernate.persister.entity.Loadable;
import org.hibernate.pretty.MessageHelper;
import org.hibernate.proxy.HibernateProxy;
import org.hibernate.type.EntityType;
import org.hibernate.type.Type;

public class OgmLoader
implements UniqueEntityLoader {
    private static final Log log = LoggerFactory.make();
    private final OgmEntityPersister[] entityPersisters;
    private final OgmCollectionPersister[] collectionPersisters;
    private final SessionFactoryImplementor factory;
    private final LockMode[] defaultLockModes;
    private final CollectionAliases[] collectionAliases;
    private final GridDialect gridDialect;

    public OgmLoader(OgmCollectionPersister[] collectionPersisters) {
        if (collectionPersisters == null || collectionPersisters.length == 0) {
            throw new AssertionFailure("CollectionPersister[] must not be null or empty");
        }
        this.entityPersisters = new OgmEntityPersister[0];
        this.collectionPersisters = collectionPersisters;
        this.factory = collectionPersisters[0].getFactory();
        this.gridDialect = (GridDialect)this.factory.getServiceRegistry().getService(GridDialect.class);
        boolean fromSize = true;
        this.defaultLockModes = ArrayHelper.fillArray((LockMode)LockMode.NONE, (int)1);
        this.collectionAliases = new CollectionAliases[collectionPersisters.length];
        for (int i = 0; i < collectionPersisters.length; ++i) {
            this.collectionAliases[i] = new OgmColumnCollectionAliases(collectionPersisters[i]);
        }
    }

    public OgmLoader(OgmEntityPersister[] entityPersisters) {
        if (entityPersisters == null || entityPersisters.length == 0) {
            throw new AssertionFailure("EntityPersister[] must not be null or empty");
        }
        this.entityPersisters = entityPersisters;
        this.collectionPersisters = new OgmCollectionPersister[0];
        this.factory = entityPersisters[0].getFactory();
        this.gridDialect = (GridDialect)this.factory.getServiceRegistry().getService(GridDialect.class);
        boolean fromSize = true;
        this.defaultLockModes = ArrayHelper.fillArray((LockMode)LockMode.NONE, (int)1);
        this.collectionAliases = new CollectionAliases[0];
    }

    public CollectionAliases[] getCollectionAliases() {
        return this.collectionAliases;
    }

    private SessionFactoryImplementor getFactory() {
        return this.factory;
    }

    public Object load(Serializable id, Object optionalObject, SessionImplementor session) throws HibernateException {
        return this.load(id, optionalObject, session, LockOptions.NONE);
    }

    public Object load(Serializable id, Object optionalObject, SessionImplementor session, LockOptions lockOptions) {
        List<Object> results = this.loadEntity(id, optionalObject, session, lockOptions, OgmLoadingContext.EMPTY_CONTEXT);
        if (results.size() == 1) {
            return results.get(0);
        }
        if (results.size() == 0) {
            return null;
        }
        throw new HibernateException("More than one row with the given identifier was found: " + id + ", for class: " + this.getEntityPersisters()[0].getEntityName());
    }

    private List<Object> loadEntity(Serializable id, Object optionalObject, SessionImplementor session, LockOptions lockOptions, OgmLoadingContext ogmLoadingContext) {
        OgmEntityPersister currentPersister = this.entityPersisters[0];
        if (log.isDebugEnabled()) {
            if (id != null) {
                log.debug("loading entity: " + MessageHelper.infoString((EntityPersister)currentPersister, (Object)id, (Type)currentPersister.getIdentifierType(), (SessionFactoryImplementor)session.getFactory()));
            } else {
                log.debug("loading entities from list of tuples: " + MessageHelper.infoString((EntityPersister)currentPersister, (Object)id, (Type)currentPersister.getIdentifierType(), (SessionFactoryImplementor)session.getFactory()));
            }
        }
        QueryParameters qp = new QueryParameters();
        qp.setPositionalParameterTypes(new Type[]{currentPersister.getIdentifierType()});
        qp.setPositionalParameterValues(new Object[]{id});
        qp.setOptionalObject(optionalObject);
        qp.setOptionalEntityName(currentPersister.getEntityName());
        qp.setOptionalId(id);
        qp.setLockOptions(lockOptions);
        List<Object> result = this.doQueryAndInitializeNonLazyCollections(session, qp, ogmLoadingContext, false);
        return result;
    }

    public List<Object> loadEntities(SessionImplementor session, LockOptions lockOptions, OgmLoadingContext ogmContext) {
        return this.loadEntity(null, null, session, lockOptions, ogmContext);
    }

    public final void loadCollection(SessionImplementor session, Serializable id, Type type) throws HibernateException {
        if (log.isDebugEnabled()) {
            log.debug("loading collection: " + MessageHelper.collectionInfoString((CollectionPersister)this.getCollectionPersisters()[0], (Serializable)id, (SessionFactoryImplementor)this.getFactory()));
        }
        Object[] ids = new Serializable[]{id};
        QueryParameters qp = new QueryParameters(new Type[]{type}, ids, (Serializable[])ids);
        this.doQueryAndInitializeNonLazyCollections(session, qp, OgmLoadingContext.EMPTY_CONTEXT, true);
        log.debug("done loading collection");
    }

    OgmEntityPersister[] getEntityPersisters() {
        return this.entityPersisters;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<Object> doQueryAndInitializeNonLazyCollections(SessionImplementor session, QueryParameters qp, OgmLoadingContext ogmLoadingContext, boolean returnProxies) {
        List<Object> result;
        PersistenceContext persistenceContext = session.getPersistenceContext();
        boolean defaultReadOnlyOrig = persistenceContext.isDefaultReadOnly();
        persistenceContext.beforeLoad();
        try {
            try {
                result = this.doQuery(session, qp, ogmLoadingContext, returnProxies);
            }
            finally {
                persistenceContext.afterLoad();
            }
            persistenceContext.initializeNonLazyCollections();
        }
        finally {
            persistenceContext.setDefaultReadOnly(defaultReadOnlyOrig);
        }
        log.debug("done entity load");
        return result;
    }

    private List<Object> doQuery(SessionImplementor session, QueryParameters qp, OgmLoadingContext ogmLoadingContext, boolean returnProxies) {
        ArrayList<Object> hydratedObjects;
        int entitySpan = this.entityPersisters.length;
        ArrayList<Object> arrayList = hydratedObjects = entitySpan == 0 ? null : new ArrayList<Object>(entitySpan * 10);
        Object id = qp.getOptionalId() != null ? qp.getOptionalId() : (ogmLoadingContext.hasResultSet() ? null : qp.getCollectionKeys()[0]);
        TupleAsMapResultSet resultset = this.getResultSet((Serializable)id, ogmLoadingContext, session);
        this.handleEmptyCollections(qp.getCollectionKeys(), resultset, session);
        org.hibernate.engine.spi.EntityKey[] keys = new org.hibernate.engine.spi.EntityKey[entitySpan];
        Object result = null;
        ArrayList<Object> results = new ArrayList<Object>();
        try {
            while (resultset.next()) {
                result = this.getRowFromResultSet(resultset, session, qp, ogmLoadingContext, qp.getOptionalId(), hydratedObjects, keys, returnProxies);
                results.add(result);
            }
        }
        catch (SQLException e) {
            // empty catch block
        }
        this.initializeEntitiesAndCollections(hydratedObjects, resultset, session, qp.isReadOnly(session));
        return results;
    }

    private void handleEmptyCollections(Serializable[] keys, ResultSet resultSetId, SessionImplementor session) {
        if (keys != null) {
            CollectionPersister[] collectionPersisters = this.getCollectionPersisters();
            for (int j = 0; j < collectionPersisters.length; ++j) {
                for (int i = 0; i < keys.length; ++i) {
                    if (log.isDebugEnabled()) {
                        log.debug("result set contains (possibly empty) collection: " + MessageHelper.collectionInfoString((CollectionPersister)collectionPersisters[j], (Serializable)keys[i], (SessionFactoryImplementor)this.getFactory()));
                    }
                    session.getPersistenceContext().getLoadContexts().getCollectionLoadContext(resultSetId).getLoadingCollection(collectionPersisters[j], keys[i]);
                }
            }
        }
    }

    private Object getRowFromResultSet(ResultSet resultset, SessionImplementor session, QueryParameters qp, OgmLoadingContext ogmLoadingContext, Serializable optionalId, List<Object> hydratedObjects, org.hibernate.engine.spi.EntityKey[] keys, boolean returnProxies) throws SQLException {
        OgmEntityPersister[] persisters = this.getEntityPersisters();
        int entitySpan = persisters.length;
        this.extractKeysFromResultSet(session, optionalId, ogmLoadingContext, keys);
        this.registerNonExists(keys, (Loadable[])persisters, session);
        if (resultset == null) {
            return null;
        }
        Object[] row = this.getRow(resultset.unwrap(TupleAsMapResultSet.class).getTuple(), persisters, keys, qp.getOptionalObject(), OgmLoader.getOptionalObjectKey(qp, session), this.getLockModes(qp.getLockOptions()), hydratedObjects, session);
        this.readCollectionElements(row, resultset, session);
        if (returnProxies) {
            for (int i = 0; i < entitySpan; ++i) {
                Object entity = row[i];
                Object proxy = session.getPersistenceContext().proxyFor((EntityPersister)persisters[i], keys[i], entity);
                if (entity == proxy) continue;
                ((HibernateProxy)proxy).getHibernateLazyInitializer().setImplementation(entity);
                row[i] = proxy;
            }
        }
        return this.getResultColumnOrRow(row);
    }

    private void extractKeysFromResultSet(SessionImplementor session, Serializable optionalId, OgmLoadingContext ogmLoadingContext, org.hibernate.engine.spi.EntityKey[] keys) {
        if (keys.length != 0) {
            org.hibernate.engine.spi.EntityKey key;
            if (optionalId == null) {
                OgmEntityPersister currentPersister = this.entityPersisters[0];
                Tuple tuple = ogmLoadingContext.getResultSet().getTuple();
                GridType gridIdentifierType = currentPersister.getGridIdentifierType();
                optionalId = (Serializable)gridIdentifierType.nullSafeGet(tuple, currentPersister.getIdentifierColumnNames(), session, null);
            }
            keys[0] = key = session.generateEntityKey(optionalId, (EntityPersister)this.entityPersisters[0]);
        }
    }

    private TupleAsMapResultSet getResultSet(Serializable id, OgmLoadingContext ogmLoadingContext, SessionImplementor session) {
        if (id == null && ogmLoadingContext.hasResultSet()) {
            return ogmLoadingContext.getResultSet();
        }
        TupleAsMapResultSet resultset = new TupleAsMapResultSet();
        if (this.getEntityPersisters().length > 0) {
            OgmEntityPersister persister = this.getEntityPersisters()[0];
            EntityKey key = EntityKeyBuilder.fromPersister(persister, id, session);
            Tuple entry = this.gridDialect.getTuple(key, persister.getTupleContext());
            if (entry != null) {
                resultset.addTuple(entry);
            }
        } else {
            if (this.getCollectionPersisters().length != 1) {
                throw new AssertionFailure("Found an unexpected number of collection persisters: " + this.getCollectionPersisters().length);
            }
            OgmCollectionPersister persister = (OgmCollectionPersister)this.getCollectionPersisters()[0];
            Object owner = session.getPersistenceContext().getCollectionOwner(id, (CollectionPersister)persister);
            AssociationPersister associationPersister = new AssociationPersister(persister.getOwnerEntityPersister().getMappedClass()).gridDialect(this.gridDialect).key(id, persister.getKeyGridType()).associationKeyMetadata(persister.getAssociationKeyMetadata()).associationTypeContext(persister.getAssociationTypeContext()).hostingEntity(owner).session(session);
            Association assoc = associationPersister.getAssociationOrNull();
            if (assoc != null) {
                for (RowKey rowKey : assoc.getKeys()) {
                    resultset.addTuple(assoc.get(rowKey));
                }
            }
        }
        return resultset;
    }

    private Object getResultColumnOrRow(Object[] row) {
        return row.length == 1 ? row[0] : row;
    }

    private void readCollectionElements(Object[] row, ResultSet resultSet, SessionImplementor session) throws HibernateException, SQLException {
        CollectionPersister[] collectionPersisters = this.getCollectionPersisters();
        if (collectionPersisters != null) {
            Object collectionOwners = null;
            for (int i = 0; i < collectionPersisters.length; ++i) {
                CollectionAliases[] descriptors = this.getCollectionAliases();
                boolean hasCollectionOwners = collectionOwners != null && collectionOwners[i] > -1;
                Object owner = hasCollectionOwners ? row[collectionOwners[i]] : null;
                CollectionPersister collectionPersister = collectionPersisters[i];
                Serializable key = owner == null ? null : collectionPersister.getCollectionType().getKeyOfOwner(owner, session);
                this.readCollectionElement(owner, key, collectionPersister, descriptors[i], resultSet, session);
            }
        }
    }

    private void readCollectionElement(Object optionalOwner, Serializable optionalKey, CollectionPersister persister, CollectionAliases descriptor, ResultSet rs, SessionImplementor session) throws HibernateException, SQLException {
        PersistenceContext persistenceContext = session.getPersistenceContext();
        Serializable collectionRowKey = (Serializable)persister.readKey(rs, descriptor.getSuffixedKeyAliases(), session);
        if (collectionRowKey != null) {
            PersistentCollection rowCollection;
            Object owner;
            if (log.isDebugEnabled()) {
                log.debug("found row of collection: " + MessageHelper.collectionInfoString((CollectionPersister)persister, (Serializable)collectionRowKey, (SessionFactoryImplementor)this.getFactory()));
            }
            if ((owner = optionalOwner) != null || (owner = persistenceContext.getCollectionOwner(collectionRowKey, persister)) == null) {
                // empty if block
            }
            if ((rowCollection = persistenceContext.getLoadContexts().getCollectionLoadContext(rs).getLoadingCollection(persister, collectionRowKey)) != null) {
                rowCollection.readFrom(rs, persister, descriptor, owner);
            }
        } else if (optionalKey != null) {
            if (log.isDebugEnabled()) {
                log.debug("result set contains (possibly empty) collection: " + MessageHelper.collectionInfoString((CollectionPersister)persister, (Serializable)optionalKey, (SessionFactoryImplementor)this.getFactory()));
            }
            persistenceContext.getLoadContexts().getCollectionLoadContext(rs).getLoadingCollection(persister, optionalKey);
        }
    }

    private void initializeEntitiesAndCollections(List hydratedObjects, ResultSet resultSetId, SessionImplementor session, boolean readOnly) throws HibernateException {
        CollectionPersister[] collectionPersisters = this.getCollectionPersisters();
        if (collectionPersisters != null) {
            for (int i = 0; i < collectionPersisters.length; ++i) {
                if (!collectionPersisters[i].isArray()) continue;
                this.endCollectionLoad(resultSetId, session, collectionPersisters[i]);
            }
        }
        PreLoadEvent pre = session.isEventSource() ? new PreLoadEvent((EventSource)session) : null;
        if (hydratedObjects != null) {
            int hydratedObjectsSize = hydratedObjects.size();
            if (log.isTraceEnabled()) {
                log.trace("total objects hydrated: " + hydratedObjectsSize);
            }
            for (int i = 0; i < hydratedObjectsSize; ++i) {
                TwoPhaseLoad.initializeEntity(hydratedObjects.get(i), (boolean)readOnly, (SessionImplementor)session, (PreLoadEvent)pre);
            }
        }
        if (collectionPersisters != null) {
            for (int i = 0; i < collectionPersisters.length; ++i) {
                if (collectionPersisters[i].isArray()) continue;
                this.endCollectionLoad(resultSetId, session, collectionPersisters[i]);
            }
        }
    }

    private void endCollectionLoad(ResultSet resultSetId, SessionImplementor session, CollectionPersister collectionPersister) {
        session.getPersistenceContext().getLoadContexts().getCollectionLoadContext(resultSetId).endLoadingCollections(collectionPersister);
    }

    protected CollectionPersister[] getCollectionPersisters() {
        return this.collectionPersisters;
    }

    protected LockMode[] getLockModes(LockOptions lockOptions) {
        if (lockOptions == null) {
            return this.defaultLockModes;
        }
        if (lockOptions.getAliasLockCount() == 0 && (lockOptions.getLockMode() == null || LockMode.NONE.equals((Object)lockOptions.getLockMode()))) {
            return this.defaultLockModes;
        }
        LockMode lockMode = lockOptions.getEffectiveLockMode("dummyaliasaswedon'thaveany");
        if (lockMode == null) {
            lockMode = LockMode.NONE;
        }
        return new LockMode[]{lockMode};
    }

    private static org.hibernate.engine.spi.EntityKey getOptionalObjectKey(QueryParameters queryParameters, SessionImplementor session) {
        Object optionalObject = queryParameters.getOptionalObject();
        Serializable optionalId = queryParameters.getOptionalId();
        String optionalEntityName = queryParameters.getOptionalEntityName();
        if (optionalObject != null && optionalEntityName != null) {
            return session.generateEntityKey(optionalId, session.getEntityPersister(optionalEntityName, optionalObject));
        }
        return null;
    }

    private Object[] getRow(Tuple resultset, OgmEntityPersister[] persisters, org.hibernate.engine.spi.EntityKey[] keys, Object optionalObject, org.hibernate.engine.spi.EntityKey optionalObjectKey, LockMode[] lockModes, List hydratedObjects, SessionImplementor session) throws HibernateException {
        if (keys.length > 1) {
            throw new NotYetImplementedException("Loading involving several entities in one result set is not yet supported in OGM");
        }
        int cols = persisters.length;
        if (log.isDebugEnabled()) {
            log.debug("result row: " + StringHelper.toString(keys));
        }
        Object[] rowResults = new Object[cols];
        for (int i = 0; i < cols; ++i) {
            Object object = null;
            org.hibernate.engine.spi.EntityKey key = keys[i];
            if (keys[i] != null) {
                object = session.getEntityUsingInterceptor(key);
                if (object != null) {
                    this.instanceAlreadyLoaded(resultset, i, persisters[i], key, object, lockModes[i], session);
                } else {
                    object = this.instanceNotYetLoaded(resultset, i, (Loadable)persisters[i], null, key, lockModes[i], optionalObjectKey, optionalObject, hydratedObjects, session);
                }
            }
            rowResults[i] = object;
        }
        return rowResults;
    }

    private void instanceAlreadyLoaded(Tuple resultset, int i, OgmEntityPersister persister, org.hibernate.engine.spi.EntityKey key, Object object, LockMode lockMode, SessionImplementor session) throws HibernateException {
        if (!persister.isInstance(object)) {
            throw new WrongClassException("loaded object was of wrong class " + object.getClass(), key.getIdentifier(), persister.getEntityName());
        }
        if (LockMode.NONE != lockMode && this.upgradeLocks()) {
            boolean isVersionCheckNeeded;
            boolean bl = isVersionCheckNeeded = persister.isVersioned() && session.getPersistenceContext().getEntry(object).getLockMode().lessThan(lockMode);
            if (isVersionCheckNeeded) {
                Object oldVersion = session.getPersistenceContext().getEntry(object).getVersion();
                persister.checkVersionAndRaiseSOSE(key.getIdentifier(), oldVersion, session, resultset);
                session.getPersistenceContext().getEntry(object).setLockMode(lockMode);
            }
        }
    }

    private Object instanceNotYetLoaded(Tuple resultset, int i, Loadable persister, String rowIdAlias, org.hibernate.engine.spi.EntityKey key, LockMode lockMode, org.hibernate.engine.spi.EntityKey optionalObjectKey, Object optionalObject, List hydratedObjects, SessionImplementor session) throws HibernateException {
        String instanceClass = this.getInstanceClass(resultset, i, persister, key.getIdentifier(), session);
        Object object = optionalObjectKey != null && key.equals((Object)optionalObjectKey) ? optionalObject : session.instantiate(instanceClass, key.getIdentifier());
        LockMode acquiredLockMode = lockMode == LockMode.NONE ? LockMode.READ : lockMode;
        this.loadFromResultSet(resultset, i, object, instanceClass, key, rowIdAlias, acquiredLockMode, persister, session);
        hydratedObjects.add(object);
        return object;
    }

    private String getInstanceClass(Tuple resultset, int i, Loadable persister, Serializable id, SessionImplementor session) throws HibernateException {
        String discriminatorColumnName = persister.getDiscriminatorColumnName();
        if (discriminatorColumnName == null) {
            return persister.getEntityName();
        }
        Object value = resultset.get(discriminatorColumnName);
        return persister.getSubclassForDiscriminatorValue(value);
    }

    private void loadFromResultSet(Tuple resultset, int i, Object object, String instanceEntityName, org.hibernate.engine.spi.EntityKey key, String rowIdAlias, LockMode lockMode, Loadable rootPersister, SessionImplementor session) throws HibernateException {
        String ukName;
        boolean eagerPropertyFetch;
        Serializable id = key.getIdentifier();
        OgmEntityPersister persister = (OgmEntityPersister)this.getFactory().getEntityPersister(instanceEntityName);
        if (log.isTraceEnabled()) {
            log.trace("Initializing object from ResultSet: " + MessageHelper.infoString((EntityPersister)persister, (Object)id, (SessionFactoryImplementor)this.getFactory()));
        }
        TwoPhaseLoad.addUninitializedEntity((org.hibernate.engine.spi.EntityKey)key, (Object)object, (EntityPersister)persister, (LockMode)lockMode, (!(eagerPropertyFetch = true) ? 1 : 0) != 0, (SessionImplementor)session);
        Object[] values = persister.hydrate(resultset, id, object, rootPersister, eagerPropertyFetch, session);
        if (persister.hasRowId()) {
            throw new HibernateException("Hibernate OGM does nto support row id");
        }
        Object rowId = null;
        EntityType[] ownerAssociationTypes = this.getOwnerAssociationTypes();
        if (ownerAssociationTypes != null && ownerAssociationTypes[i] != null && (ukName = ownerAssociationTypes[i].getRHSUniqueKeyPropertyName()) != null) {
            int index = persister.getPropertyIndex(ukName);
            Type type = persister.getPropertyTypes()[index];
            EntityUniqueKey euk = new EntityUniqueKey(rootPersister.getEntityName(), ukName, type.semiResolve(values[index], session, object), type, persister.getEntityMode(), session.getFactory());
            session.getPersistenceContext().addEntity(euk, object);
        }
        TwoPhaseLoad.postHydrate((EntityPersister)persister, (Serializable)id, (Object[])values, rowId, (Object)object, (LockMode)lockMode, (!eagerPropertyFetch ? 1 : 0) != 0, (SessionImplementor)session);
        OgmEntityEntryState.getStateFor(session, object).setTuple(resultset);
    }

    protected boolean upgradeLocks() {
        return true;
    }

    private void registerNonExists(org.hibernate.engine.spi.EntityKey[] keys, Loadable[] persisters, SessionImplementor session) {
        int[] owners = this.getOwners();
        if (owners != null) {
            EntityType[] ownerAssociationTypes = this.getOwnerAssociationTypes();
            for (int i = 0; i < keys.length; ++i) {
                boolean isOneToOneAssociation;
                int owner = owners[i];
                if (owner <= -1) continue;
                org.hibernate.engine.spi.EntityKey ownerKey = keys[owner];
                if (keys[i] != null || ownerKey == null) continue;
                PersistenceContext persistenceContext = session.getPersistenceContext();
                boolean bl = isOneToOneAssociation = ownerAssociationTypes != null && ownerAssociationTypes[i] != null && ownerAssociationTypes[i].isOneToOne();
                if (!isOneToOneAssociation) continue;
                persistenceContext.addNullProperty(ownerKey, ownerAssociationTypes[i].getPropertyName());
            }
        }
    }

    protected int[] getOwners() {
        return null;
    }

    protected EntityType[] getOwnerAssociationTypes() {
        return null;
    }
}

