/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.ogm.util.impl;

import java.io.Serializable;
import org.hibernate.engine.spi.SessionImplementor;
import org.hibernate.ogm.dialect.impl.AssociationContextImpl;
import org.hibernate.ogm.dialect.spi.AssociationContext;
import org.hibernate.ogm.dialect.spi.AssociationTypeContext;
import org.hibernate.ogm.dialect.spi.GridDialect;
import org.hibernate.ogm.entityentry.impl.OgmEntityEntryState;
import org.hibernate.ogm.model.impl.EntityKeyBuilder;
import org.hibernate.ogm.model.key.spi.AssociationKey;
import org.hibernate.ogm.model.key.spi.AssociationKeyMetadata;
import org.hibernate.ogm.model.key.spi.EntityKey;
import org.hibernate.ogm.model.spi.Association;
import org.hibernate.ogm.persister.impl.OgmEntityPersister;
import org.hibernate.ogm.type.spi.GridType;
import org.hibernate.ogm.util.impl.LogicalPhysicalConverterHelper;
import org.hibernate.persister.entity.EntityPersister;

public class AssociationPersister {
    private GridType keyGridType;
    private Object key;
    private SessionImplementor session;
    private AssociationKey associationKey;
    private Association association;
    private Object[] columnValues;
    private GridDialect gridDialect;
    private AssociationContext associationContext;
    private AssociationTypeContext associationTypeContext;
    private AssociationKeyMetadata associationKeyMetadata;
    private final Class<?> hostingEntityType;
    private Object hostingEntity;
    private Boolean hostingEntityRequiresReadAfterUpdate;
    private EntityPersister hostingEntityPersister;

    public AssociationPersister(Class<?> entityType) {
        this.hostingEntityType = entityType;
    }

    public AssociationPersister gridDialect(GridDialect gridDialect) {
        this.gridDialect = gridDialect;
        return this;
    }

    public AssociationPersister session(SessionImplementor session) {
        this.session = session;
        return this;
    }

    public AssociationPersister key(Object key, GridType keyGridType) {
        this.key = key;
        this.keyGridType = keyGridType;
        return this;
    }

    public AssociationPersister keyColumnValues(Object[] columnValues) {
        this.columnValues = columnValues;
        return this;
    }

    public AssociationPersister hostingEntity(Object entity) {
        this.hostingEntity = entity;
        return this;
    }

    public AssociationPersister associationTypeContext(AssociationTypeContext associationTypeContext) {
        this.associationTypeContext = associationTypeContext;
        return this;
    }

    public AssociationPersister associationKeyMetadata(AssociationKeyMetadata associationKeyMetadata) {
        this.associationKeyMetadata = associationKeyMetadata;
        return this;
    }

    private AssociationKey getAssociationKey() {
        if (this.associationKey == null) {
            Object[] columnValues = this.getKeyColumnValues();
            EntityKey ownerEntityKey = this.key != null ? EntityKeyBuilder.fromPersister((OgmEntityPersister)this.getHostingEntityPersister(), (Serializable)this.key, this.session) : new EntityKey(((OgmEntityPersister)this.getHostingEntityPersister()).getEntityKeyMetadata(), columnValues);
            this.associationKey = new AssociationKey(this.associationKeyMetadata, columnValues, ownerEntityKey);
        }
        return this.associationKey;
    }

    private Object[] getKeyColumnValues() {
        if (this.columnValues == null) {
            this.columnValues = LogicalPhysicalConverterHelper.getColumnsValuesFromObjectValue(this.key, this.keyGridType, this.associationKeyMetadata.getColumnNames(), this.session);
        }
        return this.columnValues;
    }

    public Association getAssociation() {
        if (this.association == null) {
            AssociationKey key = this.getAssociationKey();
            this.association = this.gridDialect.getAssociation(key, this.getAssociationContext());
            if (this.association == null) {
                this.association = this.gridDialect.createAssociation(key, this.getAssociationContext());
            }
        }
        return this.association;
    }

    public Association getAssociationOrNull() {
        if (this.association == null) {
            this.association = this.gridDialect.getAssociation(this.getAssociationKey(), this.getAssociationContext());
        }
        return this.association;
    }

    public void flushToDatastore() {
        if (this.getAssociation().isEmpty()) {
            this.gridDialect.removeAssociation(this.getAssociationKey(), this.getAssociationContext());
            this.association = null;
        } else {
            this.gridDialect.insertOrUpdateAssociation(this.getAssociationKey(), this.getAssociation(), this.getAssociationContext());
        }
        this.updateHostingEntityIfRequired();
    }

    private void updateHostingEntityIfRequired() {
        if (this.hostingEntity != null && this.hostingEntityRequiresReadAfterUpdate()) {
            EntityPersister entityPersister = this.getHostingEntityPersister();
            entityPersister.processUpdateGeneratedProperties(entityPersister.getIdentifier(this.hostingEntity, this.session), this.hostingEntity, new Object[entityPersister.getPropertyNames().length], this.session);
        }
    }

    public boolean hostingEntityRequiresReadAfterUpdate() {
        if (this.hostingEntityRequiresReadAfterUpdate == null) {
            boolean storedInEntityStructure = this.gridDialect.isStoredInEntityStructure(this.associationKeyMetadata, this.associationTypeContext);
            boolean hasUpdateGeneratedProperties = this.getHostingEntityPersister().hasUpdateGeneratedProperties();
            this.hostingEntityRequiresReadAfterUpdate = storedInEntityStructure && hasUpdateGeneratedProperties;
        }
        return this.hostingEntityRequiresReadAfterUpdate;
    }

    private EntityPersister getHostingEntityPersister() {
        if (this.hostingEntityPersister == null) {
            this.hostingEntityPersister = this.session.getFactory().getEntityPersister(this.hostingEntityType.getName());
        }
        return this.hostingEntityPersister;
    }

    private AssociationContext getAssociationContext() {
        if (this.associationContext == null) {
            this.associationContext = new AssociationContextImpl(this.associationTypeContext, this.hostingEntity != null ? OgmEntityEntryState.getStateFor(this.session, this.hostingEntity).getTuple() : null);
        }
        return this.associationContext;
    }
}

