/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.commons.util.concurrent;

import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.infinispan.commons.util.concurrent.BaseNotifyingFuture;
import org.infinispan.commons.util.concurrent.NotifyingNotifiableFuture;

public class NotifyingFutureImpl<T>
extends BaseNotifyingFuture<T>
implements NotifyingNotifiableFuture<T> {
    private T actualReturnValue;
    private Throwable exceptionThrown;
    private volatile Future<T> future;
    private final CountDownLatch latch = new CountDownLatch(1);

    @Override
    public void setFuture(Future<T> future) {
        this.future = future;
        this.latch.countDown();
    }

    public Future<T> getFuture() throws InterruptedException {
        this.latch.await();
        return this.future;
    }

    @Override
    public boolean cancel(boolean mayInterruptIfRunning) {
        try {
            return this.getFuture().cancel(mayInterruptIfRunning);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            return false;
        }
    }

    @Override
    public boolean isCancelled() {
        try {
            return this.getFuture().isCancelled();
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            return false;
        }
    }

    @Override
    public boolean isDone() {
        if (this.callCompleted) {
            return true;
        }
        try {
            return this.getFuture().isDone();
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            return false;
        }
    }

    @Override
    public T get() throws InterruptedException, ExecutionException {
        if (!this.callCompleted) {
            this.getFuture().get();
        }
        if (this.exceptionThrown != null) {
            throw new ExecutionException(this.exceptionThrown);
        }
        return this.actualReturnValue;
    }

    @Override
    public T get(long timeout, TimeUnit unit) throws InterruptedException, ExecutionException, TimeoutException {
        if (!this.callCompleted) {
            this.getFuture().get(timeout, unit);
        }
        if (this.exceptionThrown != null) {
            throw new ExecutionException(this.exceptionThrown);
        }
        return this.actualReturnValue;
    }

    @Override
    public void notifyDone(T result) {
        this.actualReturnValue = result;
        this.fireListeners();
    }

    @Override
    public void notifyException(Throwable exception) {
        this.exceptionThrown = exception;
        this.fireListeners();
    }
}

