/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.ogm.dialect.batch.spi;

import java.util.HashSet;
import java.util.LinkedList;
import java.util.Queue;
import java.util.Set;
import org.hibernate.ogm.dialect.batch.spi.InsertOrUpdateTupleOperation;
import org.hibernate.ogm.dialect.batch.spi.Operation;
import org.hibernate.ogm.model.key.spi.EntityKey;
import org.hibernate.ogm.util.impl.Log;
import org.hibernate.ogm.util.impl.LoggerFactory;

public class OperationsQueue {
    public static final OperationsQueue CLOSED_QUEUE = new OperationsQueue(){

        @Override
        public boolean isClosed() {
            return true;
        }
    };
    private static final Log log = LoggerFactory.make();
    private final Queue<Operation> operations = new LinkedList<Operation>();
    private final Set<EntityKey> entityKeys = new HashSet<EntityKey>();
    private boolean closed = false;

    public void add(InsertOrUpdateTupleOperation operation) {
        this.validate();
        this.entityKeys.add(operation.getEntityKey());
        this.addOperation(operation);
    }

    public void add(Operation operation) {
        this.validate();
        this.addOperation(operation);
    }

    private void validate() {
        if (this.isClosed()) {
            throw log.closedOperationQueue();
        }
    }

    private void addOperation(Operation operation) {
        log.debugf("Add batched operation %1$s", operation);
        this.operations.add(operation);
    }

    public Operation poll() {
        this.validate();
        Operation operation = this.operations.poll();
        this.entityKeys.remove(operation);
        return operation;
    }

    public void close() {
        this.entityKeys.clear();
        this.operations.clear();
        this.closed = true;
    }

    public boolean isClosed() {
        return this.closed;
    }

    public boolean contains(EntityKey key) {
        return this.entityKeys.contains(key);
    }

    public int size() {
        return this.operations.size();
    }
}

