/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.ogm.datastore.infinispan.persistencestrategy.impl;

import java.net.URL;
import java.util.Set;
import org.hibernate.engine.transaction.jta.platform.spi.JtaPlatform;
import org.hibernate.ogm.datastore.infinispan.persistencestrategy.impl.KeyProvider;
import org.hibernate.ogm.datastore.infinispan.persistencestrategy.impl.LocalCacheManager;
import org.hibernate.ogm.datastore.infinispan.persistencestrategy.kind.impl.OnePerKindCacheManager;
import org.hibernate.ogm.datastore.infinispan.persistencestrategy.kind.impl.OnePerKindKeyProvider;
import org.hibernate.ogm.datastore.infinispan.persistencestrategy.table.externalizer.impl.PersistentAssociationKey;
import org.hibernate.ogm.datastore.infinispan.persistencestrategy.table.externalizer.impl.PersistentEntityKey;
import org.hibernate.ogm.datastore.infinispan.persistencestrategy.table.externalizer.impl.PersistentIdSourceKey;
import org.hibernate.ogm.datastore.infinispan.persistencestrategy.table.impl.PerTableCacheManager;
import org.hibernate.ogm.datastore.infinispan.persistencestrategy.table.impl.PerTableKeyProvider;
import org.hibernate.ogm.datastore.keyvalue.options.CacheMappingType;
import org.hibernate.ogm.model.key.spi.AssociationKey;
import org.hibernate.ogm.model.key.spi.AssociationKeyMetadata;
import org.hibernate.ogm.model.key.spi.EntityKey;
import org.hibernate.ogm.model.key.spi.EntityKeyMetadata;
import org.hibernate.ogm.model.key.spi.IdSourceKey;
import org.hibernate.ogm.model.key.spi.IdSourceKeyMetadata;
import org.infinispan.manager.EmbeddedCacheManager;

public class PersistenceStrategy<EK, AK, ISK> {
    private final LocalCacheManager<EK, AK, ISK> cacheManager;
    private final KeyProvider<EK, AK, ISK> keyProvider;

    private PersistenceStrategy(LocalCacheManager<EK, AK, ISK> cacheManager, KeyProvider<EK, AK, ISK> keyProvider) {
        this.cacheManager = cacheManager;
        this.keyProvider = keyProvider;
    }

    public static PersistenceStrategy<?, ?, ?> getInstance(CacheMappingType cacheMapping, EmbeddedCacheManager externalCacheManager, URL configurationUrl, JtaPlatform jtaPlatform, Set<EntityKeyMetadata> entityTypes, Set<AssociationKeyMetadata> associationTypes, Set<IdSourceKeyMetadata> idSourceTypes) {
        if (cacheMapping == CacheMappingType.CACHE_PER_KIND) {
            return PersistenceStrategy.getPerKindStrategy(externalCacheManager, configurationUrl, jtaPlatform);
        }
        return PersistenceStrategy.getPerTableStrategy(externalCacheManager, configurationUrl, jtaPlatform, entityTypes, associationTypes, idSourceTypes);
    }

    private static PersistenceStrategy<?, ?, ?> getPerKindStrategy(EmbeddedCacheManager externalCacheManager, URL configUrl, JtaPlatform platform) {
        OnePerKindKeyProvider keyProvider = new OnePerKindKeyProvider();
        OnePerKindCacheManager cacheManager = externalCacheManager != null ? new OnePerKindCacheManager(externalCacheManager) : new OnePerKindCacheManager(configUrl, platform, keyProvider);
        return new PersistenceStrategy<EntityKey, AssociationKey, IdSourceKey>(cacheManager, keyProvider);
    }

    private static PersistenceStrategy<?, ?, ?> getPerTableStrategy(EmbeddedCacheManager externalCacheManager, URL configUrl, JtaPlatform platform, Set<EntityKeyMetadata> entityTypes, Set<AssociationKeyMetadata> associationTypes, Set<IdSourceKeyMetadata> idSourceTypes) {
        PerTableKeyProvider keyProvider = new PerTableKeyProvider();
        PerTableCacheManager cacheManager = externalCacheManager != null ? new PerTableCacheManager(externalCacheManager, entityTypes, associationTypes, idSourceTypes) : new PerTableCacheManager(configUrl, platform, entityTypes, associationTypes, idSourceTypes);
        return new PersistenceStrategy<PersistentEntityKey, PersistentAssociationKey, PersistentIdSourceKey>(cacheManager, keyProvider);
    }

    public LocalCacheManager<EK, AK, ISK> getCacheManager() {
        return this.cacheManager;
    }

    public KeyProvider<EK, AK, ISK> getKeyProvider() {
        return this.keyProvider;
    }
}

