/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.hql.lucene.internal.builder;

import java.text.ParseException;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import org.apache.lucene.document.DateTools;
import org.hibernate.hql.ParsingException;
import org.hibernate.hql.ast.spi.PropertyHelper;
import org.hibernate.search.bridge.FieldBridge;
import org.hibernate.search.bridge.TwoWayStringBridge;
import org.hibernate.search.bridge.builtin.NumericEncodingCalendarBridge;
import org.hibernate.search.bridge.builtin.NumericEncodingDateBridge;
import org.hibernate.search.bridge.builtin.NumericFieldBridge;
import org.hibernate.search.bridge.builtin.StringEncodingCalendarBridge;
import org.hibernate.search.bridge.builtin.StringEncodingDateBridge;
import org.hibernate.search.bridge.builtin.impl.NullEncodingTwoWayFieldBridge;
import org.hibernate.search.bridge.builtin.impl.TwoWayString2FieldBridgeAdaptor;

public abstract class LucenePropertyHelper
implements PropertyHelper {
    public Object convertToPropertyType(String entityType, List<String> propertyPath, String value) {
        FieldBridge bridge = this.getFieldBridge(entityType, propertyPath);
        return this.convertToPropertyType(entityType, propertyPath, value, bridge);
    }

    private Object convertToPropertyType(String entityType, List<String> propertyPath, String value, FieldBridge bridge) {
        if (bridge instanceof NullEncodingTwoWayFieldBridge) {
            return this.convertToPropertyType(entityType, propertyPath, value, (FieldBridge)((NullEncodingTwoWayFieldBridge)bridge).unwrap());
        }
        if (bridge instanceof TwoWayString2FieldBridgeAdaptor) {
            return ((TwoWayString2FieldBridgeAdaptor)bridge).unwrap().stringToObject(value);
        }
        if (bridge instanceof TwoWayStringBridge) {
            return ((TwoWayStringBridge)bridge).stringToObject(value);
        }
        if (bridge instanceof NumericFieldBridge) {
            NumericFieldBridge numericBridge = (NumericFieldBridge)bridge;
            switch (numericBridge) {
                case INT_FIELD_BRIDGE: {
                    return Integer.valueOf(value);
                }
                case LONG_FIELD_BRIDGE: {
                    return Long.valueOf(value);
                }
                case FLOAT_FIELD_BRIDGE: {
                    return Float.valueOf(value);
                }
                case DOUBLE_FIELD_BRIDGE: {
                    return Double.valueOf(value);
                }
            }
            return value;
        }
        if (bridge instanceof StringEncodingCalendarBridge || bridge instanceof NumericEncodingCalendarBridge) {
            Date date = this.parseDate(value);
            Calendar calendar = Calendar.getInstance();
            calendar.setTime(date);
            return calendar;
        }
        if (bridge instanceof StringEncodingDateBridge || bridge instanceof NumericEncodingDateBridge) {
            return this.parseDate(value);
        }
        return value;
    }

    private Date parseDate(String value) {
        try {
            return DateTools.stringToDate((String)value);
        }
        catch (ParseException e) {
            throw new ParsingException((Throwable)e);
        }
    }

    public abstract FieldBridge getFieldBridge(String var1, List<String> var2);
}

