/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.api.properties;

import java.util.Arrays;
import org.neo4j.kernel.api.properties.CharArrayProperty;
import org.neo4j.kernel.api.properties.DefinedProperty;
import org.neo4j.kernel.impl.cache.SizeOfs;

class StringArrayProperty
extends DefinedProperty {
    final String[] value;

    StringArrayProperty(int propertyKeyId, String[] value) {
        super(propertyKeyId);
        assert (value != null);
        this.value = value;
    }

    public String[] value() {
        return (String[])this.value.clone();
    }

    @Override
    public boolean valueEquals(Object other) {
        String[] value = this.value;
        return StringArrayProperty.valueEquals(value, other);
    }

    static boolean valueEquals(String[] value, Object other) {
        if (other instanceof String[]) {
            return Arrays.equals(value, (String[])other);
        }
        if (other instanceof char[]) {
            return CharArrayProperty.eq(value, (char[])other);
        }
        if (other instanceof Character[]) {
            Character[] that = (Character[])other;
            if (value.length == that.length) {
                for (int i = 0; i < that.length; ++i) {
                    String str = value[i];
                    Character character = that[i];
                    if (character != null && str.length() == 1 && str.charAt(0) == character.charValue()) continue;
                    return false;
                }
                return true;
            }
            return false;
        }
        return false;
    }

    @Override
    int valueHash() {
        return StringArrayProperty.hash(this.value);
    }

    static int hash(String[] value) {
        return Arrays.hashCode(value);
    }

    @Override
    boolean hasEqualValue(DefinedProperty other) {
        if (other instanceof StringArrayProperty) {
            StringArrayProperty that = (StringArrayProperty)other;
            return Arrays.equals(this.value, that.value);
        }
        if (other instanceof CharArrayProperty) {
            CharArrayProperty that = (CharArrayProperty)other;
            return CharArrayProperty.eq(this.value, that.value);
        }
        return false;
    }

    @Override
    public int sizeOfObjectInBytesIncludingOverhead() {
        return SizeOfs.withObjectOverhead(SizeOfs.withReference(SizeOfs.sizeOfArray(this.value)));
    }
}

