/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.configuration;

import java.util.HashMap;
import java.util.Map;
import java.util.regex.Pattern;
import org.neo4j.helpers.Args;
import org.neo4j.kernel.configuration.BaseConfigurationMigrator;

public class GraphDatabaseConfigurationMigrator
extends BaseConfigurationMigrator {
    private static final String KEEP_LOGICAL_LOGS = "keep_logical_logs";

    public GraphDatabaseConfigurationMigrator() {
        this.add(new BaseConfigurationMigrator.SpecificPropertyMigration("enable_online_backup", "enable_online_backup has been replaced with online_backup_enabled and online_backup_port"){

            @Override
            public void setValueWithOldSetting(String value, Map<String, String> rawConfiguration) {
                if (value != null) {
                    String port = null;
                    if (value.contains("=")) {
                        Args args = GraphDatabaseConfigurationMigrator.parseMapFromConfigValue("enable_online_backup", value);
                        port = args.get("port", "6362");
                        port = "0.0.0.0:" + port;
                    } else if (Boolean.parseBoolean(value)) {
                        port = "0.0.0.0:6362-6372";
                    }
                    if (port != null) {
                        rawConfiguration.put("online_backup_server", port);
                        rawConfiguration.put("online_backup_enabled", "true");
                    }
                }
            }
        });
        this.add(new BaseConfigurationMigrator.SpecificPropertyMigration("online_backup_port", "online_backup_port has been replaced with online_backup_server, which is a hostname:port setting"){

            @Override
            public void setValueWithOldSetting(String value, Map<String, String> rawConfiguration) {
                if (value != null) {
                    rawConfiguration.put("online_backup_server", "0.0.0.0:" + value);
                }
            }
        });
        this.add(new BaseConfigurationMigrator.SpecificPropertyMigration("neo4j.ext.udc.disable", "neo4j.ext.udc.disable has been replaced with neo4j.ext.udc.enabled"){

            @Override
            public void setValueWithOldSetting(String value, Map<String, String> rawConfiguration) {
                if ("true".equalsIgnoreCase(value)) {
                    rawConfiguration.put("neo4j.ext.udc.enabled", "false");
                } else {
                    rawConfiguration.put("neo4j.ext.udc.enabled", "true");
                }
            }
        });
        this.add(new BaseConfigurationMigrator.SpecificPropertyMigration("enable_remote_shell", "enable_remote_shell has been replaced with remote_shell_enabled"){

            @Override
            public void setValueWithOldSetting(String value, Map<String, String> rawConfiguration) {
                if (GraphDatabaseConfigurationMigrator.configValueContainsMultipleParameters(value)) {
                    rawConfiguration.put("remote_shell_enabled", "true");
                    Args parsed = GraphDatabaseConfigurationMigrator.parseMapFromConfigValue("enable_remote_shell", value);
                    HashMap<String, String> map = new HashMap<String, String>();
                    map.put("remote_shell_port", parsed.get("port", "1337"));
                    map.put("remote_shell_name", parsed.get("name", "shell"));
                    map.put("remote_shell_read_only", parsed.get("readonly", "false"));
                    rawConfiguration.putAll(map);
                } else {
                    rawConfiguration.put("remote_shell_enabled", Boolean.parseBoolean(value) ? "true" : "false");
                }
            }
        });
        this.add(new BaseConfigurationMigrator.SpecificPropertyMigration(KEEP_LOGICAL_LOGS, "multi-value configuration of keep_logical_logs has been removed, any configuration specified will apply to all data sources"){

            @Override
            public boolean appliesTo(Map<String, String> rawConfiguration) {
                return GraphDatabaseConfigurationMigrator.configValueContainsMultipleParameters(rawConfiguration.get(GraphDatabaseConfigurationMigrator.KEEP_LOGICAL_LOGS));
            }

            @Override
            public void setValueWithOldSetting(String value, Map<String, String> rawConfiguration) {
                boolean keep = false;
                Args map = GraphDatabaseConfigurationMigrator.parseMapFromConfigValue(GraphDatabaseConfigurationMigrator.KEEP_LOGICAL_LOGS, value);
                for (Map.Entry<String, String> entry : map.asMap().entrySet()) {
                    if (!Boolean.parseBoolean(entry.getValue())) continue;
                    keep = true;
                    break;
                }
                rawConfiguration.put(GraphDatabaseConfigurationMigrator.KEEP_LOGICAL_LOGS, String.valueOf(keep));
            }
        });
        this.add(new BaseConfigurationMigrator.SpecificPropertyMigration("lucene_writer_cache_size", "cannot configure writers and searchers individually since they go together"){

            @Override
            public void setValueWithOldSetting(String value, Map<String, String> rawConfiguration) {
            }
        });
        this.add(new BaseConfigurationMigrator.ConfigValueChanged("cache_type", "gcr", "hpc", "'gcr' cache type has been renamed to 'hpc', High Performance Cache."));
    }

    @Deprecated
    public static boolean configValueContainsMultipleParameters(String configValue) {
        return configValue != null && configValue.contains("=");
    }

    @Deprecated
    public static Args parseMapFromConfigValue(String name, String configValue) {
        HashMap<String, String> result = new HashMap<String, String>();
        for (String part : configValue.split(Pattern.quote(","))) {
            String[] tokens = part.split(Pattern.quote("="));
            if (tokens.length != 2) {
                throw new RuntimeException("Invalid configuration value '" + configValue + "' for " + name + ". The format is [true/false] or [key1=value1,key2=value2...]");
            }
            result.put(tokens[0], tokens[1]);
        }
        return new Args(result);
    }
}

