/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.api;

import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArraySet;
import org.neo4j.helpers.Pair;
import org.neo4j.kernel.api.KernelTransaction;
import org.neo4j.kernel.api.TransactionHook;
import org.neo4j.kernel.api.TxState;
import org.neo4j.kernel.api.exceptions.TransactionHookException;

public class TransactionHooks {
    protected final Set<TransactionHook> hooks = new CopyOnWriteArraySet<TransactionHook>();

    public void register(TransactionHook hook) {
        this.hooks.add(hook);
    }

    public void unregister(TransactionHook hook) {
        this.hooks.remove(hook);
    }

    public TransactionHooksState beforeCommit(TxState state, KernelTransaction tx) {
        if (this.hooks.size() == 0) {
            return null;
        }
        TransactionHooksState hookState = new TransactionHooksState();
        for (TransactionHook hook : this.hooks) {
            hookState.add(hook, (TransactionHook.Outcome)hook.beforeCommit(state, tx));
        }
        return hookState;
    }

    public void afterCommit(TxState state, KernelTransaction tx, TransactionHooksState hooksState) {
        if (hooksState == null) {
            return;
        }
        for (Pair<TransactionHook, TransactionHook.Outcome> hookAndOutcome : hooksState.hooksWithOutcome()) {
            hookAndOutcome.first().afterCommit(state, tx, hookAndOutcome.other());
        }
    }

    public void afterRollback(TxState state, KernelTransaction tx, TransactionHooksState hooksState) {
        if (hooksState == null) {
            return;
        }
        for (Pair<TransactionHook, TransactionHook.Outcome> hookAndOutcome : hooksState.hooksWithOutcome()) {
            hookAndOutcome.first().afterRollback(state, tx, hookAndOutcome.other());
        }
    }

    public static class TransactionHooksState {
        private final List<Pair<TransactionHook, TransactionHook.Outcome>> hooksWithAttachment = new ArrayList<Pair<TransactionHook, TransactionHook.Outcome>>();
        private TransactionHookException failure;

        public void add(TransactionHook hook, TransactionHook.Outcome outcome) {
            this.hooksWithAttachment.add(Pair.of(hook, outcome));
            if (outcome != null && !outcome.isSuccessful()) {
                this.failure = new TransactionHookException(outcome.failure(), "Transaction handler failed.", new Object[0]);
            }
        }

        public Iterable<Pair<TransactionHook, TransactionHook.Outcome>> hooksWithOutcome() {
            return this.hooksWithAttachment;
        }

        public boolean failed() {
            return this.failure != null;
        }

        public TransactionHookException failure() {
            return this.failure;
        }
    }
}

