/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.core;

import java.util.Iterator;
import org.neo4j.graphdb.Direction;
import org.neo4j.kernel.impl.core.FirstRelationshipIds;
import org.neo4j.kernel.impl.core.NodeImpl;
import org.neo4j.kernel.impl.core.NodeManager;
import org.neo4j.kernel.impl.core.RelationshipLoadingPosition;
import org.neo4j.kernel.impl.nioneo.store.Record;
import org.neo4j.kernel.impl.util.RelIdArray;
import org.neo4j.kernel.impl.util.RelationshipFilter;

public class DenseNodeImpl
extends NodeImpl {
    DenseNodeImpl(long id) {
        super(id);
    }

    @Override
    public int getDegree(NodeManager nm, int type) {
        return this.getDegree(nm, type, Direction.BOTH);
    }

    @Override
    public int getDegree(NodeManager nm, Direction direction) {
        return nm.getRelationshipCount(this, -1, RelIdArray.wrap(direction));
    }

    @Override
    public int getDegree(NodeManager nm, int type, Direction direction) {
        return nm.getRelationshipCount(this, type, RelIdArray.wrap(direction));
    }

    @Override
    public Iterator<Integer> getRelationshipTypes(NodeManager nm) {
        return this.hasMoreRelationshipsToLoad() ? nm.getRelationshipTypes(this) : super.getRelationshipTypes(nm);
    }

    @Override
    protected boolean isDense() {
        return true;
    }

    @Override
    protected RelationshipFilter filterForAddingRelationships(final FirstRelationshipIds firstRelationshipIdsToCommit, final RelationshipLoadingPosition relChainPosition) {
        return new RelationshipFilter(){

            @Override
            public boolean accept(int type, RelIdArray.DirectionWrapper direction, long firstCachedId) {
                long firstIdToCommit = firstRelationshipIdsToCommit.firstIdOf(type, direction);
                assert (firstIdToCommit != (long)Record.NO_NEXT_RELATIONSHIP.intValue()) : "About to add relationships of " + type + " " + (Object)((Object)direction) + " to node " + DenseNodeImpl.this.getId() + ", but apparently the tx state says that no such relationships " + "are to be added " + firstRelationshipIdsToCommit;
                return firstCachedId == (long)Record.NO_NEXT_RELATIONSHIP.intValue() ? this.relationshipChainAtPosition(relChainPosition, direction, type, firstIdToCommit) : firstCachedId != firstIdToCommit;
            }

            private boolean relationshipChainAtPosition(RelationshipLoadingPosition relChainPosition2, RelIdArray.DirectionWrapper direction, int type, long firstIdToCommit) {
                return relChainPosition2 != null && !relChainPosition2.atPosition(direction, type, firstIdToCommit);
            }
        };
    }
}

