/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.storemigration.legacystore.v20;

import java.io.File;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import org.neo4j.helpers.UTF8;
import org.neo4j.helpers.collection.IteratorUtil;
import org.neo4j.helpers.collection.PrefetchingIterator;
import org.neo4j.kernel.impl.nioneo.store.FileSystemAbstraction;
import org.neo4j.kernel.impl.nioneo.store.NodeRecord;
import org.neo4j.kernel.impl.nioneo.store.Record;
import org.neo4j.kernel.impl.nioneo.store.StoreChannel;
import org.neo4j.kernel.impl.storemigration.legacystore.LegacyNodeStoreReader;
import org.neo4j.kernel.impl.storemigration.legacystore.v20.Legacy20Store;

public class Legacy20NodeStoreReader
implements LegacyNodeStoreReader {
    public static final String FROM_VERSION = "NodeStore v0.A.1";
    public static final int RECORD_SIZE = 14;
    private final StoreChannel fileChannel;
    private final long maxId;

    public Legacy20NodeStoreReader(FileSystemAbstraction fs, File fileName) throws IOException {
        this.fileChannel = fs.open(fileName, "r");
        int endHeaderSize = UTF8.encode(FROM_VERSION).length;
        this.maxId = (this.fileChannel.size() - (long)endHeaderSize) / 14L;
    }

    @Override
    public long getMaxId() {
        return this.maxId;
    }

    public void accept(LegacyNodeStoreReader.Visitor visitor) throws IOException {
        ByteBuffer buffer = ByteBuffer.allocateDirect(57344);
        long fileSize = this.fileChannel.size();
        for (long position = 0L; position < fileSize; position += (long)buffer.capacity()) {
            buffer.clear();
            this.fileChannel.read(buffer, position);
            for (int recordOffset = 0; recordOffset < buffer.capacity() && (long)recordOffset + position < fileSize; recordOffset += 14) {
                buffer.position(recordOffset);
                long id = (position + (long)recordOffset) / 14L;
                visitor.visit(this.readRecord(buffer, id));
            }
        }
    }

    @Override
    public Iterator<NodeRecord> iterator() throws IOException {
        final ByteBuffer buffer = ByteBuffer.allocateDirect(57344);
        final long fileSize = this.fileChannel.size();
        return new PrefetchingIterator<NodeRecord>(){
            private long position = 0L;
            private final Collection<NodeRecord> pageRecords = new ArrayList<NodeRecord>();
            private Iterator<NodeRecord> pageRecordsIterator = IteratorUtil.emptyIterator();

            @Override
            protected NodeRecord fetchNextOrNull() {
                if (this.pageRecordsIterator.hasNext()) {
                    return this.pageRecordsIterator.next();
                }
                while (this.position < fileSize) {
                    buffer.clear();
                    try {
                        Legacy20NodeStoreReader.this.fileChannel.read(buffer, this.position);
                    }
                    catch (IOException e) {
                        throw new RuntimeException(e);
                    }
                    this.pageRecords.clear();
                    for (int pageOffset = 0; pageOffset < buffer.capacity() && (long)pageOffset + this.position < fileSize; pageOffset += 14) {
                        buffer.position(pageOffset);
                        long id = (this.position + (long)pageOffset) / 14L;
                        NodeRecord record = Legacy20NodeStoreReader.this.readRecord(buffer, id);
                        if (!record.inUse()) continue;
                        this.pageRecords.add(record);
                    }
                    this.position += (long)buffer.capacity();
                    this.pageRecordsIterator = this.pageRecords.iterator();
                    if (!this.pageRecordsIterator.hasNext()) continue;
                    return this.pageRecordsIterator.next();
                }
                return null;
            }
        };
    }

    private NodeRecord readRecord(ByteBuffer buffer, long id) {
        NodeRecord nodeRecord;
        boolean inUse;
        long inUseByte = buffer.get();
        boolean bl = inUse = (inUseByte & 1L) == (long)Record.IN_USE.intValue();
        if (inUse) {
            long nextRel = Legacy20Store.getUnsignedInt(buffer);
            long relModifier = (inUseByte & 0xEL) << 31;
            long nextProp = Legacy20Store.getUnsignedInt(buffer);
            long propModifier = (inUseByte & 0xF0L) << 28;
            long lsbLabels = Legacy20Store.getUnsignedInt(buffer);
            long hsbLabels = buffer.get() & 0xFF;
            long labels = lsbLabels | hsbLabels << 32;
            nodeRecord = new NodeRecord(id, false, Legacy20Store.longFromIntAndMod(nextRel, relModifier), Legacy20Store.longFromIntAndMod(nextProp, propModifier));
            nodeRecord.setLabelField(labels, Collections.emptyList());
        } else {
            nodeRecord = new NodeRecord(id, false, Record.NO_NEXT_RELATIONSHIP.intValue(), Record.NO_NEXT_PROPERTY.intValue());
        }
        nodeRecord.setInUse(inUse);
        return nodeRecord;
    }

    @Override
    public void close() throws IOException {
        this.fileChannel.close();
    }
}

