/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.ogm.cfg;

import java.util.Properties;
import org.hibernate.HibernateException;
import org.hibernate.MappingException;
import org.hibernate.cfg.Configuration;
import org.hibernate.engine.spi.Mapping;
import org.hibernate.engine.spi.SessionFactoryImplementor;
import org.hibernate.id.factory.IdentifierGeneratorFactory;
import org.hibernate.id.factory.spi.MutableIdentifierGeneratorFactory;
import org.hibernate.ogm.OgmSessionFactory;
import org.hibernate.ogm.cfg.Configurable;
import org.hibernate.ogm.cfg.impl.ConfigurableImpl;
import org.hibernate.ogm.cfg.impl.OgmNamingStrategy;
import org.hibernate.ogm.datastore.spi.DatastoreConfiguration;
import org.hibernate.ogm.hibernatecore.impl.OgmSessionFactoryImpl;
import org.hibernate.ogm.jpa.impl.OgmMutableIdentifierGeneratorFactory;
import org.hibernate.ogm.options.navigation.GlobalContext;
import org.hibernate.ogm.query.impl.OgmQueryTranslatorFactory;
import org.hibernate.type.Type;

public class OgmConfiguration
extends Configuration
implements Configurable {
    private final MutableIdentifierGeneratorFactory identifierGeneratorFactory = new OgmMutableIdentifierGeneratorFactory();

    public OgmConfiguration() {
        this.resetOgm();
    }

    private void resetOgm() {
        super.setNamingStrategy(OgmNamingStrategy.INSTANCE);
        this.setProperty("hibernate.ogm._activate", "true");
        this.setProperty("hibernate.search.massindexer.factoryclass", "org.hibernate.ogm.massindex.impl.OgmMassIndexerFactory");
        this.setProperty("hibernate.id.new_generator_mappings", "true");
        this.setProperty("hibernate.query.factory_class", OgmQueryTranslatorFactory.class.getName());
    }

    public Mapping buildMapping() {
        final Mapping delegate = super.buildMapping();
        return new Mapping(){

            public IdentifierGeneratorFactory getIdentifierGeneratorFactory() {
                return OgmConfiguration.this.identifierGeneratorFactory;
            }

            public Type getIdentifierType(String entityName) throws MappingException {
                return delegate.getIdentifierType(entityName);
            }

            public String getIdentifierPropertyName(String entityName) throws MappingException {
                return delegate.getIdentifierPropertyName(entityName);
            }

            public Type getReferencedPropertyType(String entityName, String propertyName) throws MappingException {
                return delegate.getReferencedPropertyType(entityName, propertyName);
            }
        };
    }

    public MutableIdentifierGeneratorFactory getIdentifierGeneratorFactory() {
        return this.identifierGeneratorFactory;
    }

    @Deprecated
    public OgmSessionFactory buildSessionFactory() throws HibernateException {
        return new OgmSessionFactoryImpl((SessionFactoryImplementor)super.buildSessionFactory());
    }

    public Configuration setProperties(Properties properties) {
        super.setProperties(properties);
        if (!properties.containsKey("hibernate.ogm._activate")) {
            this.setProperty("hibernate.ogm._activate", "true");
        }
        if (!properties.containsKey("hibernate.search.massindexer.factoryclass")) {
            this.setProperty("hibernate.search.massindexer.factoryclass", "org.hibernate.ogm.massindex.OgmMassIndexerFactory");
        }
        if (!properties.containsKey("hibernate.id.new_generator_mappings")) {
            this.setProperty("hibernate.id.new_generator_mappings", "true");
        }
        if (!properties.containsKey("hibernate.query.factory_class")) {
            this.setProperty("hibernate.query.factory_class", OgmQueryTranslatorFactory.class.getName());
        }
        return this;
    }

    @Override
    public <D extends DatastoreConfiguration<G>, G extends GlobalContext<?, ?>> G configureOptionsFor(Class<D> datastoreType) {
        ConfigurableImpl configurable = new ConfigurableImpl();
        this.getProperties().put("hibernate.ogm.options.context", configurable.getContext());
        return configurable.configureOptionsFor(datastoreType);
    }
}

