/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.ogm.datastore.document.association.spi;

import org.hibernate.ogm.datastore.document.association.spi.AssociationRow;
import org.hibernate.ogm.datastore.document.association.spi.AssociationRowFactory;
import org.hibernate.ogm.datastore.document.association.spi.impl.DocumentHelpers;
import org.hibernate.ogm.model.key.spi.AssociationKey;
import org.hibernate.ogm.util.impl.Contracts;

public abstract class StructureOptimizerAssociationRowFactory<R>
implements AssociationRowFactory {
    private final Class<?> associationRowType;

    protected StructureOptimizerAssociationRowFactory(Class<?> associationRowType) {
        this.associationRowType = associationRowType;
    }

    @Override
    public AssociationRow<?> createAssociationRow(AssociationKey associationKey, Object row) {
        AssociationRow.AssociationRowAccessor<R> accessor;
        Object rowObject = null;
        if (this.associationRowType.isInstance(row)) {
            String[] associationKeyColumns = associationKey.getMetadata().getAssociatedEntityKeyMetadata().getAssociationKeyColumns();
            String prefix = DocumentHelpers.getColumnSharedPrefix(associationKeyColumns);
            accessor = this.getAssociationRowAccessor(associationKeyColumns, prefix);
            rowObject = row;
        } else {
            accessor = this.getAssociationRowAccessor(null, null);
            String columnName = associationKey.getMetadata().getSingleRowKeyColumnNotContainedInAssociationKey();
            Contracts.assertNotNull(columnName, "columnName");
            rowObject = this.getSingleColumnRow(columnName, row);
        }
        return new AssociationRow<Object>(associationKey, accessor, rowObject);
    }

    protected abstract R getSingleColumnRow(String var1, Object var2);

    protected abstract AssociationRow.AssociationRowAccessor<R> getAssociationRowAccessor(String[] var1, String var2);
}

