/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.ogm.jpa.impl;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.hibernate.id.enhanced.SequenceStyleGenerator;
import org.hibernate.id.enhanced.TableGenerator;
import org.hibernate.jpa.spi.IdentifierGeneratorStrategyProvider;
import org.hibernate.ogm.jpa.impl.OgmMutableIdentifierGeneratorFactory;

public class OgmIdentifierGeneratorStrategyProvider
implements IdentifierGeneratorStrategyProvider {
    public Map<String, Class<?>> getStrategies() {
        Map<String, Class<?>> strategies = this.strategies();
        return Collections.unmodifiableMap(strategies);
    }

    private Map<String, Class<?>> strategies() {
        HashMap strategies = new HashMap();
        this.add(strategies, TableGenerator.class.getName());
        this.add(strategies, SequenceStyleGenerator.class.getName());
        this.add(strategies, "identity");
        return strategies;
    }

    private void add(Map<String, Class<?>> strategies, String strategy) {
        OgmMutableIdentifierGeneratorFactory factory = new OgmMutableIdentifierGeneratorFactory();
        strategies.put(strategy, factory.getIdentifierGeneratorClass(strategy));
    }
}

