/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.ogm.persister.impl;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.hibernate.AssertionFailure;
import org.hibernate.HibernateException;
import org.hibernate.LockMode;
import org.hibernate.LockOptions;
import org.hibernate.MappingException;
import org.hibernate.StaleObjectStateException;
import org.hibernate.bytecode.instrumentation.spi.LazyPropertyInitializer;
import org.hibernate.cache.spi.CacheKey;
import org.hibernate.cache.spi.access.EntityRegionAccessStrategy;
import org.hibernate.cache.spi.access.NaturalIdRegionAccessStrategy;
import org.hibernate.cache.spi.entry.CacheEntry;
import org.hibernate.dialect.lock.LockingStrategy;
import org.hibernate.engine.OptimisticLockStyle;
import org.hibernate.engine.internal.Versioning;
import org.hibernate.engine.spi.EntityEntry;
import org.hibernate.engine.spi.LoadQueryInfluencers;
import org.hibernate.engine.spi.Mapping;
import org.hibernate.engine.spi.SessionFactoryImplementor;
import org.hibernate.engine.spi.SessionImplementor;
import org.hibernate.internal.DynamicFilterAliasGenerator;
import org.hibernate.internal.FilterAliasGenerator;
import org.hibernate.loader.entity.UniqueEntityLoader;
import org.hibernate.mapping.Column;
import org.hibernate.mapping.PersistentClass;
import org.hibernate.mapping.Table;
import org.hibernate.ogm.dialect.identity.spi.IdentityColumnAwareGridDialect;
import org.hibernate.ogm.dialect.impl.AssociationTypeContextImpl;
import org.hibernate.ogm.dialect.impl.ExceptionThrowingLockingStrategy;
import org.hibernate.ogm.dialect.impl.TupleContextImpl;
import org.hibernate.ogm.dialect.optimisticlock.spi.OptimisticLockingAwareGridDialect;
import org.hibernate.ogm.dialect.spi.DuplicateInsertPreventionStrategy;
import org.hibernate.ogm.dialect.spi.GridDialect;
import org.hibernate.ogm.dialect.spi.TupleAlreadyExistsException;
import org.hibernate.ogm.dialect.spi.TupleContext;
import org.hibernate.ogm.entityentry.impl.OgmEntityEntryState;
import org.hibernate.ogm.exception.NotSupportedException;
import org.hibernate.ogm.id.impl.OgmIdentityGenerator;
import org.hibernate.ogm.loader.impl.OgmLoader;
import org.hibernate.ogm.model.impl.DefaultAssociatedEntityKeyMetadata;
import org.hibernate.ogm.model.impl.DefaultAssociationKeyMetadata;
import org.hibernate.ogm.model.impl.DefaultEntityKeyMetadata;
import org.hibernate.ogm.model.impl.EntityKeyBuilder;
import org.hibernate.ogm.model.key.spi.AssociatedEntityKeyMetadata;
import org.hibernate.ogm.model.key.spi.AssociationKeyMetadata;
import org.hibernate.ogm.model.key.spi.EntityKey;
import org.hibernate.ogm.model.key.spi.EntityKeyMetadata;
import org.hibernate.ogm.model.spi.Association;
import org.hibernate.ogm.model.spi.AssociationKind;
import org.hibernate.ogm.model.spi.Tuple;
import org.hibernate.ogm.options.spi.OptionsService;
import org.hibernate.ogm.persister.impl.EntityAssociationUpdater;
import org.hibernate.ogm.persister.impl.EntityDiscriminator;
import org.hibernate.ogm.persister.impl.OgmCollectionPersister;
import org.hibernate.ogm.type.spi.GridType;
import org.hibernate.ogm.type.spi.TypeTranslator;
import org.hibernate.ogm.util.impl.ArrayHelper;
import org.hibernate.ogm.util.impl.AssociationPersister;
import org.hibernate.ogm.util.impl.CollectionHelper;
import org.hibernate.ogm.util.impl.Log;
import org.hibernate.ogm.util.impl.LoggerFactory;
import org.hibernate.persister.entity.AbstractEntityPersister;
import org.hibernate.persister.entity.EntityPersister;
import org.hibernate.persister.entity.Joinable;
import org.hibernate.persister.entity.Loadable;
import org.hibernate.persister.entity.Lockable;
import org.hibernate.pretty.MessageHelper;
import org.hibernate.property.BackrefPropertyAccessor;
import org.hibernate.service.spi.ServiceRegistryImplementor;
import org.hibernate.tuple.GenerationTiming;
import org.hibernate.tuple.NonIdentifierAttribute;
import org.hibernate.tuple.ValueGeneration;
import org.hibernate.tuple.entity.EntityMetamodel;
import org.hibernate.type.AssociationType;
import org.hibernate.type.ComponentType;
import org.hibernate.type.EntityType;
import org.hibernate.type.IntegerType;
import org.hibernate.type.OneToOneType;
import org.hibernate.type.Type;

public abstract class OgmEntityPersister
extends AbstractEntityPersister
implements EntityPersister {
    private static final int TABLE_SPAN = 1;
    private static final Log log = LoggerFactory.make();
    private final EntityDiscriminator discriminator;
    private final String tableName;
    private final String[] constraintOrderedTableNames;
    private final String[][] constraintOrderedKeyColumnNames;
    private final String[] spaces;
    private final String[] subclassSpaces;
    private final GridType[] gridPropertyTypes;
    private final GridType gridVersionType;
    private final GridType gridIdentifierType;
    private final String jpaEntityName;
    private final GridDialect gridDialect;
    private final IdentityColumnAwareGridDialect identityColumnAwareGridDialect;
    private final OptimisticLockingAwareGridDialect optimisticLockingAwareGridDialect;
    private final OptionsService optionsService;
    private final EntityKeyMetadata entityKeyMetadata;
    private final DuplicateInsertPreventionStrategy duplicateInsertPreventionStrategy;
    private Map<String, AssociationKeyMetadata> inverseOneToOneAssociationKeyMetadata;
    private final boolean[] propertyMightRequireInverseAssociationManagement;
    private final boolean mightRequireInverseAssociationManagement;
    private final boolean usesNonAtomicOptimisticLocking;
    private TupleContext tupleContext;

    OgmEntityPersister(PersistentClass persistentClass, EntityRegionAccessStrategy cacheAccessStrategy, NaturalIdRegionAccessStrategy naturalIdRegionAccessStrategy, SessionFactoryImplementor factory, Mapping mapping, EntityDiscriminator discriminator) throws HibernateException {
        super(persistentClass, cacheAccessStrategy, naturalIdRegionAccessStrategy, factory);
        if (log.isTraceEnabled()) {
            log.tracef("Creating OgmEntityPersister for %s", persistentClass.getClassName());
        }
        ServiceRegistryImplementor serviceRegistry = factory.getServiceRegistry();
        this.gridDialect = (GridDialect)serviceRegistry.getService(GridDialect.class);
        this.identityColumnAwareGridDialect = (IdentityColumnAwareGridDialect)serviceRegistry.getService(IdentityColumnAwareGridDialect.class);
        this.optimisticLockingAwareGridDialect = (OptimisticLockingAwareGridDialect)serviceRegistry.getService(OptimisticLockingAwareGridDialect.class);
        this.optionsService = (OptionsService)serviceRegistry.getService(OptionsService.class);
        if (factory.getIdentifierGenerator(this.getEntityName()) instanceof OgmIdentityGenerator && this.identityColumnAwareGridDialect == null) {
            throw log.getIdentityGenerationStrategyNotSupportedException(this.getEntityName());
        }
        this.tableName = persistentClass.getTable().getQualifiedName(factory.getDialect(), factory.getSettings().getDefaultCatalogName(), factory.getSettings().getDefaultSchemaName());
        this.discriminator = discriminator;
        int spacesSize = 1 + persistentClass.getSynchronizedTables().size();
        this.spaces = new String[spacesSize];
        this.spaces[0] = this.tableName;
        Iterator syncTablesIter = persistentClass.getSynchronizedTables().iterator();
        for (int i = 1; i < spacesSize; ++i) {
            this.spaces[i] = (String)syncTablesIter.next();
        }
        HashSet<String> subclassTables = new HashSet<String>();
        Iterator tableIter = persistentClass.getSubclassTableClosureIterator();
        while (tableIter.hasNext()) {
            Table table = (Table)tableIter.next();
            subclassTables.add(table.getQualifiedName(factory.getDialect(), factory.getSettings().getDefaultCatalogName(), factory.getSettings().getDefaultSchemaName()));
        }
        this.subclassSpaces = ArrayHelper.toStringArray(subclassTables);
        if (this.isMultiTable()) {
            int idColumnSpan = this.getIdentifierColumnSpan();
            ArrayList<String> tableNames = new ArrayList<String>();
            ArrayList<String[]> keyColumns = new ArrayList<String[]>();
            if (!this.isAbstract()) {
                tableNames.add(this.tableName);
                keyColumns.add(this.getIdentifierColumnNames());
            }
            Iterator iter = persistentClass.getSubclassTableClosureIterator();
            while (iter.hasNext()) {
                Table tab = (Table)iter.next();
                if (tab.isAbstractUnionTable()) continue;
                String tableName = tab.getQualifiedName(factory.getDialect(), factory.getSettings().getDefaultCatalogName(), factory.getSettings().getDefaultSchemaName());
                tableNames.add(tableName);
                String[] key = new String[idColumnSpan];
                Iterator citer = tab.getPrimaryKey().getColumnIterator();
                for (int k = 0; k < idColumnSpan; ++k) {
                    key[k] = ((Column)citer.next()).getQuotedName(factory.getDialect());
                }
                keyColumns.add(key);
            }
            this.constraintOrderedTableNames = ArrayHelper.toStringArray(tableNames);
            this.constraintOrderedKeyColumnNames = ArrayHelper.to2DStringArray(keyColumns);
        } else {
            this.constraintOrderedTableNames = new String[]{this.tableName};
            this.constraintOrderedKeyColumnNames = new String[][]{this.getIdentifierColumnNames()};
        }
        this.initPropertyPaths(mapping);
        TypeTranslator typeTranslator = (TypeTranslator)serviceRegistry.getService(TypeTranslator.class);
        Type[] types = this.getPropertyTypes();
        int length = types.length;
        this.gridPropertyTypes = new GridType[length];
        for (int index = 0; index < length; ++index) {
            try {
                this.gridPropertyTypes[index] = typeTranslator.getType(types[index]);
                continue;
            }
            catch (Exception e) {
                throw log.couldNotConfigureProperty(this.getEntityName(), this.getPropertyNames()[index], e);
            }
        }
        this.gridVersionType = typeTranslator.getType((Type)this.getVersionType());
        this.gridIdentifierType = typeTranslator.getType(this.getIdentifierType());
        this.jpaEntityName = persistentClass.getJpaEntityName();
        this.entityKeyMetadata = new DefaultEntityKeyMetadata(this.getTableName(), this.getIdentifierColumnNames());
        this.duplicateInsertPreventionStrategy = this.gridDialect.getDuplicateInsertPreventionStrategy(this.entityKeyMetadata);
        this.initCustomSQLStrings();
        this.propertyMightRequireInverseAssociationManagement = this.getPropertyMightRequireInverseAssociationManagement();
        this.mightRequireInverseAssociationManagement = this.initMayManageInverseAssociations();
        this.usesNonAtomicOptimisticLocking = this.initUsesNonAtomicOptimisticLocking();
        this.initLockers();
    }

    private void initCustomSQLStrings() {
        this.customSQLInsert = new String[1];
        this.customSQLUpdate = new String[1];
        this.customSQLDelete = new String[1];
    }

    private Map<String, AssociationKeyMetadata> initInverseOneToOneAssociationKeyMetadata() {
        HashMap<String, AssociationKeyMetadata> associationKeyMetadata = new HashMap<String, AssociationKeyMetadata>();
        for (String property : this.getPropertyNames()) {
            Type propertyType = this.getPropertyType(property);
            if (!propertyType.isEntityType()) continue;
            String[] propertyColumnNames = this.getPropertyColumnNames(this.getPropertyIndex(property));
            String[] rowKeyColumnNames = this.buildRowKeyColumnNamesForStarToOne(this, propertyColumnNames);
            OgmEntityPersister otherSidePersister = (OgmEntityPersister)((EntityType)propertyType).getAssociatedJoinable(this.getFactory());
            String inverseOneToOneProperty = this.getInverseOneToOneProperty(property, otherSidePersister);
            if (inverseOneToOneProperty == null) continue;
            DefaultAssociationKeyMetadata metadata = new DefaultAssociationKeyMetadata.Builder().table(this.getTableName()).columnNames(propertyColumnNames).rowKeyColumnNames(rowKeyColumnNames).associatedEntityKeyMetadata(new DefaultAssociatedEntityKeyMetadata(this.entityKeyMetadata.getColumnNames(), this.entityKeyMetadata)).inverse(true).collectionRole(inverseOneToOneProperty).associationKind(AssociationKind.ASSOCIATION).oneToOne(true).build();
            associationKeyMetadata.put(property, metadata);
        }
        return associationKeyMetadata;
    }

    private String getInverseOneToOneProperty(String property, OgmEntityPersister otherSidePersister) {
        for (String candidate : otherSidePersister.getPropertyNames()) {
            Type candidateType = otherSidePersister.getPropertyType(candidate);
            if (!candidateType.isEntityType() || !((EntityType)candidateType).isOneToOne() || !OgmEntityPersister.isOneToOneMatching(this, property, (OneToOneType)candidateType)) continue;
            return candidate;
        }
        return null;
    }

    private static boolean isOneToOneMatching(OgmEntityPersister mainSidePersister, String mainSideProperty, OneToOneType inversePropertyType) {
        SessionFactoryImplementor factory = mainSidePersister.getFactory();
        String associatedProperty = inversePropertyType.getRHSUniqueKeyPropertyName();
        return mainSidePersister == inversePropertyType.getAssociatedJoinable(factory) && mainSideProperty.equals(associatedProperty);
    }

    private List<String> selectableColumnNames(EntityDiscriminator discriminator) {
        ArrayList<String> columnNames = new ArrayList<String>();
        for (int propertyCount = 0; propertyCount < this.getPropertySpan(); ++propertyCount) {
            String[] property = this.getPropertyColumnNames(propertyCount);
            for (int columnCount = 0; columnCount < property.length; ++columnCount) {
                columnNames.add(property[columnCount]);
            }
        }
        if (discriminator.getColumnName() != null) {
            columnNames.add(discriminator.getColumnName());
        }
        columnNames.addAll(this.getEmbeddedCollectionColumns());
        return columnNames;
    }

    private List<String> getEmbeddedCollectionColumns() {
        ArrayList<String> embeddedCollections = new ArrayList<String>();
        for (String property : this.getPropertyNames()) {
            Type propertyType = this.getPropertyType(property);
            if (propertyType.isAssociationType()) {
                Joinable associatedJoinable = ((AssociationType)propertyType).getAssociatedJoinable(this.getFactory());
                if (associatedJoinable.isCollection()) {
                    OgmCollectionPersister inversePersister = (OgmCollectionPersister)associatedJoinable;
                    if (!this.gridDialect.isStoredInEntityStructure(inversePersister.getAssociationKeyMetadata(), inversePersister.getAssociationTypeContext(property))) continue;
                    embeddedCollections.add(property);
                    continue;
                }
                embeddedCollections.add(property);
                continue;
            }
            if (!propertyType.isComponentType()) continue;
            this.collectEmbeddedCollectionColumns((ComponentType)propertyType, property, embeddedCollections);
        }
        return embeddedCollections;
    }

    private void collectEmbeddedCollectionColumns(ComponentType componentType, String dotName, List<String> embeddedCollections) {
        for (String propertyName : componentType.getPropertyNames()) {
            Type type = componentType.getSubtypes()[componentType.getPropertyIndex(propertyName)];
            if (type.isCollectionType()) {
                embeddedCollections.add(dotName + "." + propertyName);
                continue;
            }
            if (!type.isComponentType()) continue;
            this.collectEmbeddedCollectionColumns((ComponentType)type, dotName + "." + propertyName, embeddedCollections);
        }
    }

    private boolean[] getPropertyMightRequireInverseAssociationManagement() {
        boolean[] propertyMightRequireInverseAssociationManagement = new boolean[this.getEntityMetamodel().getPropertySpan()];
        for (int propertyIndex = 0; propertyIndex < this.getEntityMetamodel().getPropertySpan(); ++propertyIndex) {
            Type propertyType = this.getPropertyTypes()[propertyIndex];
            boolean isStarToOne = propertyType.isAssociationType() && !propertyType.isCollectionType();
            propertyMightRequireInverseAssociationManagement[propertyIndex] = isStarToOne || this.getPropertyUniqueness()[propertyIndex];
        }
        return propertyMightRequireInverseAssociationManagement;
    }

    private boolean initMayManageInverseAssociations() {
        for (boolean mightManageReverseAssociation : this.propertyMightRequireInverseAssociationManagement) {
            if (!mightManageReverseAssociation) continue;
            return true;
        }
        return false;
    }

    private boolean initUsesNonAtomicOptimisticLocking() {
        boolean usesNonAtomicOptimisticLocking;
        boolean bl = usesNonAtomicOptimisticLocking = this.optimisticLockingAwareGridDialect == null && this.isVersioned() || this.isAllOrDirtyOptLocking();
        if (usesNonAtomicOptimisticLocking) {
            log.usingNonAtomicOptimisticLocking(this.getEntityName());
        }
        return usesNonAtomicOptimisticLocking;
    }

    protected void createUniqueKeyLoaders() throws MappingException {
    }

    protected void doPostInstantiate() {
        this.inverseOneToOneAssociationKeyMetadata = Collections.unmodifiableMap(this.initInverseOneToOneAssociationKeyMetadata());
        this.tupleContext = this.createTupleContext();
    }

    private TupleContext createTupleContext() {
        HashMap<String, AssociatedEntityKeyMetadata> associatedEntityKeyMetadata = CollectionHelper.newHashMap();
        HashMap<String, String> roles = CollectionHelper.newHashMap();
        for (int index = 0; index < this.getPropertySpan(); ++index) {
            Type uniqueKeyType = this.getPropertyTypes()[index];
            if (!uniqueKeyType.isEntityType()) continue;
            OgmEntityPersister associatedJoinable = (OgmEntityPersister)this.getFactory().getEntityPersister(((EntityType)uniqueKeyType).getAssociatedEntityName());
            for (String column : this.getPropertyColumnNames(index)) {
                associatedEntityKeyMetadata.put(column, new DefaultAssociatedEntityKeyMetadata(this.getPropertyColumnNames(index), associatedJoinable.getEntityKeyMetadata()));
                roles.put(column, this.getPropertyNames()[index]);
            }
        }
        return new TupleContextImpl(this.selectableColumnNames(this.discriminator), associatedEntityKeyMetadata, roles, this.optionsService.context().getEntityOptions(this.getMappedClass()));
    }

    public GridType getGridIdentifierType() {
        return this.gridIdentifierType;
    }

    public EntityKeyMetadata getEntityKeyMetadata() {
        return this.entityKeyMetadata;
    }

    public EntityKeyMetadata getRootEntityKeyMetadata() {
        return this.entityKeyMetadata;
    }

    public Object[] getDatabaseSnapshot(Serializable id, SessionImplementor session) throws HibernateException {
        Tuple resultset;
        if (log.isTraceEnabled()) {
            log.trace("Getting current persistent state for: " + MessageHelper.infoString((EntityPersister)this, (Object)id, (SessionFactoryImplementor)this.getFactory()));
        }
        if ((resultset = this.getResultsetById(id, session)) == null || resultset.getSnapshot().isEmpty()) {
            return null;
        }
        GridType[] types = this.gridPropertyTypes;
        Object[] values = new Object[types.length];
        boolean[] includeProperty = this.getPropertyUpdateability();
        for (int i = 0; i < types.length; ++i) {
            if (!includeProperty[i]) continue;
            values[i] = types[i].hydrate(resultset, this.getPropertyAliases("", i), session, null);
        }
        return values;
    }

    private Tuple getResultsetById(Serializable id, SessionImplementor session) {
        EntityKey key = EntityKeyBuilder.fromPersister(this, id, session);
        Tuple resultset = this.gridDialect.getTuple(key, this.getTupleContext());
        return resultset;
    }

    public Object initializeLazyProperty(String fieldName, Object entity, SessionImplementor session) throws HibernateException {
        Serializable id = session.getContextEntityIdentifier(entity);
        EntityEntry entry = session.getPersistenceContext().getEntry(entity);
        if (entry == null) {
            throw new HibernateException("entity is not associated with the session: " + id);
        }
        if (log.isTraceEnabled()) {
            log.trace("initializing lazy properties of: " + MessageHelper.infoString((EntityPersister)this, (Object)id, (SessionFactoryImplementor)this.getFactory()) + ", field access: " + fieldName);
        }
        if (this.hasCache()) {
            CacheEntry cacheEntry;
            CacheKey cacheKey = session.generateCacheKey(id, this.getIdentifierType(), this.getEntityName());
            Object ce = this.getCacheAccessStrategy().get((Object)cacheKey, session.getTimestamp());
            if (ce != null && !(cacheEntry = (CacheEntry)this.getCacheEntryStructure().destructure(ce, this.getFactory())).areLazyPropertiesUnfetched()) {
                return this.initializeLazyPropertiesFromCache(fieldName, entity, session, entry, cacheEntry);
            }
        }
        return this.initializeLazyPropertiesFromDatastore(fieldName, entity, session, id, entry);
    }

    private Object initializeLazyPropertiesFromCache(String fieldName, Object entity, SessionImplementor session, EntityEntry entry, CacheEntry cacheEntry) {
        throw new NotSupportedException("OGM-9", "Lazy properties not supported in OGM");
    }

    private Object initializeLazyPropertiesFromDatastore(String fieldName, Object entity, SessionImplementor session, Serializable id, EntityEntry entry) {
        throw new NotSupportedException("OGM-9", "Lazy properties not supported in OGM");
    }

    public Object getCurrentVersion(Serializable id, SessionImplementor session) throws HibernateException {
        Tuple resultset;
        if (log.isTraceEnabled()) {
            log.trace("Getting version: " + MessageHelper.infoString((EntityPersister)this, (Object)id, (SessionFactoryImplementor)this.getFactory()));
        }
        if ((resultset = this.getResultsetById(id, session)) == null) {
            return null;
        }
        return this.gridVersionType.nullSafeGet(resultset, this.getVersionColumnName(), session, null);
    }

    public Object forceVersionIncrement(Serializable id, Object currentVersion, SessionImplementor session) {
        if (!this.isVersioned()) {
            throw new AssertionFailure("cannot force version increment on non-versioned entity");
        }
        if (this.isVersionPropertyGenerated()) {
            throw new HibernateException("LockMode.FORCE is currently not supported for generated version properties");
        }
        Object nextVersion = this.getVersionType().next(currentVersion, session);
        if (log.isTraceEnabled()) {
            log.trace("Forcing version increment [" + MessageHelper.infoString((EntityPersister)this, (Object)id, (SessionFactoryImplementor)this.getFactory()) + "; " + this.getVersionType().toLoggableString(currentVersion, this.getFactory()) + " -> " + this.getVersionType().toLoggableString(nextVersion, this.getFactory()) + "]");
        }
        EntityKey key = EntityKeyBuilder.fromPersister(this, id, session);
        Tuple resultset = this.gridDialect.getTuple(key, this.getTupleContext());
        this.checkVersionAndRaiseSOSE(id, currentVersion, session, resultset);
        this.gridVersionType.nullSafeSet(resultset, nextVersion, new String[]{this.getVersionColumnName()}, session);
        this.gridDialect.insertOrUpdateTuple(key, resultset, this.getTupleContext());
        return nextVersion;
    }

    public FilterAliasGenerator getFilterAliasGenerator(String rootAlias) {
        return new DynamicFilterAliasGenerator(new String[]{this.tableName}, rootAlias);
    }

    public Object loadByUniqueKey(String propertyName, Object uniqueKey, SessionImplementor session) throws HibernateException {
        int propertyIndex = this.getPropertyIndex(propertyName);
        GridType gridUniqueKeyType = this.getUniqueKeyTypeFromAssociatedEntity(propertyIndex, propertyName);
        AssociationKeyMetadata associationKeyMetadata = this.inverseOneToOneAssociationKeyMetadata.get(propertyName);
        if (associationKeyMetadata == null) {
            throw new AssertionFailure("loadByUniqueKey on a non EntityType:" + propertyName);
        }
        OgmEntityPersister inversePersister = (OgmEntityPersister)((EntityType)this.getPropertyTypes()[propertyIndex]).getAssociatedJoinable(session.getFactory());
        OptionsService.OptionsServiceContext serviceContext = ((OptionsService)session.getFactory().getServiceRegistry().getService(OptionsService.class)).context();
        AssociationTypeContextImpl associationTypeContext = new AssociationTypeContextImpl(serviceContext.getPropertyOptions(inversePersister.getMappedClass(), associationKeyMetadata.getCollectionRole()), associationKeyMetadata.getAssociatedEntityKeyMetadata(), this.getPropertyNames()[propertyIndex]);
        AssociationPersister associationPersister = new AssociationPersister(inversePersister.getMappedClass()).gridDialect(this.gridDialect).key(uniqueKey, gridUniqueKeyType).associationKeyMetadata(associationKeyMetadata).session(session).associationTypeContext(associationTypeContext).hostingEntity(session.getPersistenceContext().getEntity(new org.hibernate.engine.spi.EntityKey((Serializable)uniqueKey, (EntityPersister)inversePersister)));
        Association ids = associationPersister.getAssociationOrNull();
        if (ids == null || ids.size() == 0) {
            return null;
        }
        if (ids.size() == 1) {
            Tuple tuple = ids.get(ids.getKeys().iterator().next());
            Serializable id = (Serializable)this.getGridIdentifierType().nullSafeGet(tuple, this.getIdentifierColumnNames(), session, null);
            return this.load(id, null, LockMode.NONE, session);
        }
        throw new AssertionFailure("Loading by unique key but finding several matches: table:" + this.getTableName() + " property: " + propertyName + " value: " + uniqueKey);
    }

    private GridType getUniqueKeyTypeFromAssociatedEntity(int propertyIndex, String propertyName) {
        Type uniqueKeyType = this.getPropertyTypes()[propertyIndex];
        if (!uniqueKeyType.isEntityType()) {
            throw new AssertionFailure("loadByUniqueKey on a non EntityType:" + propertyName);
        }
        EntityType entityType = (EntityType)uniqueKeyType;
        OgmEntityPersister entityPersister = (OgmEntityPersister)entityType.getAssociatedJoinable(this.getFactory());
        GridType gridUniqueKeyType = entityPersister.getGridIdentifierType();
        return gridUniqueKeyType;
    }

    protected void createLoaders() {
        Map loaders = this.getLoaders();
        loaders.put(LockMode.NONE, this.createEntityLoader(LockMode.NONE));
        UniqueEntityLoader readLoader = this.createEntityLoader(LockMode.READ);
        loaders.put(LockMode.READ, readLoader);
        boolean disableForUpdate = this.getSubclassTableSpan() > 1 && this.hasSubclasses() && !this.getFactory().getDialect().supportsOuterJoinForUpdate();
        loaders.put(LockMode.UPGRADE, disableForUpdate ? readLoader : this.createEntityLoader(LockMode.UPGRADE));
        loaders.put(LockMode.UPGRADE_NOWAIT, disableForUpdate ? readLoader : this.createEntityLoader(LockMode.UPGRADE_NOWAIT));
        loaders.put(LockMode.FORCE, disableForUpdate ? readLoader : this.createEntityLoader(LockMode.FORCE));
        loaders.put(LockMode.PESSIMISTIC_READ, disableForUpdate ? readLoader : this.createEntityLoader(LockMode.PESSIMISTIC_READ));
        loaders.put(LockMode.PESSIMISTIC_WRITE, disableForUpdate ? readLoader : this.createEntityLoader(LockMode.PESSIMISTIC_WRITE));
        loaders.put(LockMode.PESSIMISTIC_FORCE_INCREMENT, disableForUpdate ? readLoader : this.createEntityLoader(LockMode.PESSIMISTIC_FORCE_INCREMENT));
        loaders.put(LockMode.OPTIMISTIC, this.createEntityLoader(LockMode.OPTIMISTIC));
        loaders.put(LockMode.OPTIMISTIC_FORCE_INCREMENT, this.createEntityLoader(LockMode.OPTIMISTIC_FORCE_INCREMENT));
        loaders.put("merge", this.createEntityLoader(LockMode.READ));
        loaders.put("refresh", this.createEntityLoader(LockMode.READ));
    }

    protected UniqueEntityLoader createEntityLoader(LockMode lockMode, LoadQueryInfluencers loadQueryInfluencers) throws MappingException {
        return new OgmLoader(new OgmEntityPersister[]{this});
    }

    protected UniqueEntityLoader createEntityLoader(LockOptions lockOptions, LoadQueryInfluencers loadQueryInfluencers) throws MappingException {
        return new OgmLoader(new OgmEntityPersister[]{this});
    }

    protected UniqueEntityLoader createEntityLoader(LockMode lockMode) throws MappingException {
        return this.createEntityLoader(lockMode, LoadQueryInfluencers.NONE);
    }

    public Object[] hydrate(Tuple resultset, Serializable id, Object object, Loadable rootLoadable, boolean allProperties, SessionImplementor session) throws HibernateException {
        if (log.isTraceEnabled()) {
            log.trace("Hydrating entity: " + MessageHelper.infoString((EntityPersister)this, (Object)id, (SessionFactoryImplementor)this.getFactory()));
        }
        OgmEntityPersister rootPersister = (OgmEntityPersister)rootLoadable;
        boolean hasDeferred = rootPersister.hasSequentialSelect();
        boolean sequentialSelectEmpty = false;
        if (hasDeferred) {
            // empty if block
        }
        String[] propNames = this.getPropertyNames();
        Type[] types = this.getPropertyTypes();
        Object[] values = new Object[types.length];
        boolean[] laziness = this.getPropertyLaziness();
        String[] propSubclassNames = this.getSubclassPropertySubclassNameClosure();
        boolean[] propertySelectable = this.getPropertySelectable();
        for (int i = 0; i < types.length; ++i) {
            values[i] = this.hydrateValue(resultset, session, object, i, propertySelectable, allProperties, laziness, hasDeferred, rootPersister, propNames, propSubclassNames, sequentialSelectEmpty);
        }
        return values;
    }

    private Object hydrateValue(Tuple resultset, SessionImplementor session, Object object, int index, boolean[] propertySelectable, boolean allProperties, boolean[] laziness, boolean hasDeferred, OgmEntityPersister rootPersister, String[] propNames, String[] propSubclassNames, boolean sequentialSelectEmpty) {
        Object value;
        if (!propertySelectable[index]) {
            value = BackrefPropertyAccessor.UNKNOWN;
        } else if (allProperties || !laziness[index]) {
            boolean propertyIsDeferred;
            boolean bl = propertyIsDeferred = hasDeferred && rootPersister.isSubclassPropertyDeferred(propNames[index], propSubclassNames[index]);
            if (propertyIsDeferred && sequentialSelectEmpty) {
                value = null;
            } else {
                GridType[] gridTypes = this.gridPropertyTypes;
                String[] cols = propertyIsDeferred ? this.getPropertyAliases("", index) : this.getPropertyAliases("", index);
                value = gridTypes[index].hydrate(resultset, cols, session, object);
            }
        } else {
            value = LazyPropertyInitializer.UNFETCHED_PROPERTY;
        }
        return value;
    }

    public String[] getPropertyAliases(String suffix, int i) {
        return this.getPropertyColumnNames(i);
    }

    protected boolean useInsertSelectIdentity() {
        return false;
    }

    protected Serializable insert(Object[] fields, boolean[] notNull, String sql, Object object, SessionImplementor session) throws HibernateException {
        throw new HibernateException("Cannot use a database generator with OGM");
    }

    protected LockingStrategy generateLocker(LockMode lockMode) {
        LockingStrategy lockingStrategy = this.gridDialect.getLockingStrategy((Lockable)this, lockMode);
        return lockingStrategy != null ? lockingStrategy : new ExceptionThrowingLockingStrategy(this.gridDialect, lockMode);
    }

    public void update(Serializable id, Object[] fields, int[] dirtyFields, boolean hasDirtyCollection, Object[] oldFields, Object oldVersion, Object object, Object rowId, SessionImplementor session) throws HibernateException {
        boolean[] tableUpdateNeeded = this.getTableUpdateNeeded(dirtyFields, hasDirtyCollection);
        int span = this.getTableSpan();
        EntityEntry entry = session.getPersistenceContext().getEntry(object);
        if (entry == null && !this.isMutable()) {
            throw new IllegalStateException("Updating immutable entity that is not in session yet!");
        }
        boolean[] propsToUpdate = dirtyFields != null ? this.getPropertiesToUpdate(dirtyFields, hasDirtyCollection) : (!this.isModifiableEntity(entry) ? this.getPropertiesToUpdate(dirtyFields == null ? ArrayHelper.EMPTY_INT_ARRAY : dirtyFields, hasDirtyCollection) : this.getPropertyUpdateability(object));
        SessionFactoryImplementor factory = this.getFactory();
        if (log.isTraceEnabled()) {
            log.trace("Updating entity: " + MessageHelper.infoString((EntityPersister)this, (Object)id, (SessionFactoryImplementor)factory));
            if (this.isVersioned()) {
                log.trace("Existing version: " + oldVersion + " -> New version: " + fields[this.getVersionProperty()]);
            }
        }
        for (int j = 0; j < span; ++j) {
            if (!tableUpdateNeeded[j]) continue;
            EntityKey key = EntityKeyBuilder.fromPersister(this, id, session);
            Tuple resultset = null;
            if (this.mightRequireInverseAssociationManagement || this.usesNonAtomicOptimisticLocking) {
                resultset = this.gridDialect.getTuple(key, this.getTupleContext());
            } else {
                OgmEntityEntryState extraState = (OgmEntityEntryState)entry.getExtraState(OgmEntityEntryState.class);
                if (extraState != null) {
                    resultset = extraState.getTuple();
                }
                if (resultset == null) {
                    resultset = this.gridDialect.getTuple(key, this.getTupleContext());
                }
            }
            boolean useVersion = j == 0 && this.isVersioned();
            resultset = this.createNewResultSetIfNull(key, resultset, id, session);
            EntityMetamodel entityMetamodel = this.getEntityMetamodel();
            if (this.usesNonAtomicOptimisticLocking) {
                if (useVersion && entityMetamodel.getOptimisticLockStyle() == OptimisticLockStyle.VERSION) {
                    if (this.checkVersion(propsToUpdate)) {
                        this.checkVersionAndRaiseSOSE(id, oldVersion, session, resultset);
                    }
                } else if (this.isAllOrDirtyOptLocking() && oldFields != null) {
                    boolean[] versionability = this.getPropertyVersionability();
                    boolean[] includeOldField = entityMetamodel.getOptimisticLockStyle() == OptimisticLockStyle.ALL ? this.getPropertyUpdateability() : propsToUpdate;
                    GridType[] types = this.gridPropertyTypes;
                    for (int i = 0; i < entityMetamodel.getPropertySpan(); ++i) {
                        boolean include;
                        boolean bl = include = includeOldField[i] && this.isPropertyOfTable(i, j) && versionability[i];
                        if (!include) continue;
                        GridType type = types[i];
                        boolean[] settable = type.toColumnNullness(oldFields[i], (Mapping)factory);
                        Object snapshotValue = type.nullSafeGet(resultset, this.getPropertyColumnNames(i), session, object);
                        if (type.isEqual(oldFields[i], snapshotValue, factory)) continue;
                        this.raiseStaleObjectStateException(id);
                    }
                }
            }
            if (this.mightRequireInverseAssociationManagement) {
                this.removeFromInverseAssociations(resultset, j, id, session);
            }
            this.dehydrate(resultset, fields, propsToUpdate, j, id, session);
            if (this.isVersioned() && this.optimisticLockingAwareGridDialect != null) {
                Tuple oldVersionTuple = new Tuple();
                oldVersionTuple.put(this.getVersionColumnName(), oldVersion);
                boolean success = this.optimisticLockingAwareGridDialect.updateTupleWithOptimisticLock(key, oldVersionTuple, resultset, this.getTupleContext());
                if (!success) {
                    this.raiseStaleObjectStateException(id);
                }
            } else {
                this.gridDialect.insertOrUpdateTuple(key, resultset, this.getTupleContext());
            }
            if (!this.mightRequireInverseAssociationManagement) continue;
            this.addToInverseAssociations(resultset, j, id, session);
        }
    }

    private boolean isAllOrDirtyOptLocking() {
        EntityMetamodel entityMetamodel = this.getEntityMetamodel();
        return entityMetamodel.getOptimisticLockStyle() == OptimisticLockStyle.DIRTY || entityMetamodel.getOptimisticLockStyle() == OptimisticLockStyle.ALL;
    }

    public void checkVersionAndRaiseSOSE(Serializable id, Object oldVersion, SessionImplementor session, Tuple resultset) {
        Object resultSetVersion = this.gridVersionType.nullSafeGet(resultset, this.getVersionColumnName(), session, null);
        if (!this.gridVersionType.isEqual(oldVersion, resultSetVersion, this.getFactory())) {
            this.raiseStaleObjectStateException(id);
        }
    }

    private void dehydrate(Tuple tuple, Object[] fields, boolean[] includeProperties, int tableIndex, Serializable id, SessionImplementor session) {
        if (log.isTraceEnabled()) {
            log.trace("Dehydrating entity: " + MessageHelper.infoString((EntityPersister)this, (Object)id, (SessionFactoryImplementor)this.getFactory()));
        }
        for (int propertyIndex = 0; propertyIndex < this.getEntityMetamodel().getPropertySpan(); ++propertyIndex) {
            if (!this.isPropertyOfTable(propertyIndex, tableIndex) || !includeProperties[propertyIndex]) continue;
            this.getGridPropertyTypes()[propertyIndex].nullSafeSet(tuple, fields[propertyIndex], this.getPropertyColumnNames(propertyIndex), this.getPropertyColumnInsertable()[propertyIndex], session);
        }
    }

    private void removeFromInverseAssociations(Tuple resultset, int tableIndex, Serializable id, SessionImplementor session) {
        new EntityAssociationUpdater(this).id(id).resultset(resultset).session(session).tableIndex(tableIndex).propertyMightRequireInverseAssociationManagement(this.propertyMightRequireInverseAssociationManagement).removeNavigationalInformationFromInverseSide();
    }

    private void addToInverseAssociations(Tuple resultset, int tableIndex, Serializable id, SessionImplementor session) {
        new EntityAssociationUpdater(this).id(id).resultset(resultset).session(session).tableIndex(tableIndex).propertyMightRequireInverseAssociationManagement(this.propertyMightRequireInverseAssociationManagement).addNavigationalInformationForInverseSide();
    }

    private boolean checkVersion(boolean[] includeProperty) {
        return includeProperty[this.getVersionProperty()] || this.getEntityMetamodel().isVersionGenerated();
    }

    private boolean isModifiableEntity(EntityEntry entry) {
        return entry == null ? this.isMutable() : entry.isModifiableEntity();
    }

    public Serializable insert(Object[] fields, Object object, SessionImplementor session) throws HibernateException {
        boolean[] propertiesToInsert = this.getPropertiesToInsert(fields);
        Tuple tuple = this.identityColumnAwareGridDialect.createTuple(this.entityKeyMetadata, this.getTupleContext());
        if (this.discriminator.isNeeded()) {
            tuple.put(this.getDiscriminatorColumnName(), this.getDiscriminatorValue());
        }
        this.dehydrate(tuple, fields, propertiesToInsert, 0, null, session);
        this.identityColumnAwareGridDialect.insertTuple(this.entityKeyMetadata, tuple, this.getTupleContext());
        Serializable id = (Serializable)this.getGridIdentifierType().hydrate(tuple, this.getIdentifierColumnNames(), session, object);
        this.addToInverseAssociations(tuple, 0, id, session);
        if (id == null) {
            throw new HibernateException("Dialect failed to generate id for entity type " + this.entityKeyMetadata);
        }
        OgmEntityEntryState.getStateFor(session, object).setTuple(tuple);
        return id;
    }

    public void insert(Serializable id, Object[] fields, Object object, SessionImplementor session) throws HibernateException {
        int span = this.getTableSpan();
        boolean[] propertiesToInsert = this.getPropertiesToInsert(fields);
        for (int j = 0; j < span; ++j) {
            if (this.isInverseTable(j)) {
                return;
            }
            if (this.isNullableTable(j) && this.isAllNull(fields, j)) {
                return;
            }
            if (log.isTraceEnabled()) {
                log.trace("Inserting entity: " + MessageHelper.infoString((EntityPersister)this, (Object)id, (SessionFactoryImplementor)this.getFactory()));
                if (j == 0 && this.isVersioned()) {
                    log.trace("Version: " + Versioning.getVersion((Object[])fields, (EntityPersister)this));
                }
            }
            EntityKey key = EntityKeyBuilder.fromPersister(this, id, session);
            Tuple resultset = null;
            if (this.duplicateInsertPreventionStrategy == DuplicateInsertPreventionStrategy.LOOK_UP) {
                resultset = this.gridDialect.getTuple(key, this.getTupleContext());
                if (j == 0 && resultset != null) {
                    throw log.mustNotInsertSameEntityTwice(MessageHelper.infoString((EntityPersister)this, (Object)id, (SessionFactoryImplementor)this.getFactory()), null);
                }
            }
            resultset = this.createNewResultSetIfNull(key, resultset, id, session);
            if (j == 0 && this.discriminator.isNeeded()) {
                resultset.put(this.getDiscriminatorColumnName(), this.getDiscriminatorValue());
            }
            this.dehydrate(resultset, fields, propertiesToInsert, j, id, session);
            try {
                this.gridDialect.insertOrUpdateTuple(key, resultset, this.getTupleContext());
            }
            catch (TupleAlreadyExistsException taee) {
                throw log.mustNotInsertSameEntityTwice(MessageHelper.infoString((EntityPersister)this, (Object)id, (SessionFactoryImplementor)this.getFactory()), (Exception)((Object)taee));
            }
            this.addToInverseAssociations(resultset, 0, id, session);
            OgmEntityEntryState.getStateFor(session, object).setTuple(resultset);
        }
    }

    public String getDiscriminatorColumnName() {
        return this.discriminator.getColumnName();
    }

    protected String getDiscriminatorAlias() {
        return this.discriminator.getAlias();
    }

    private Tuple createNewResultSetIfNull(EntityKey key, Tuple resultset, Serializable id, SessionImplementor session) {
        if (resultset == null) {
            resultset = this.gridDialect.createTuple(key, this.getTupleContext());
            this.gridIdentifierType.nullSafeSet(resultset, id, this.getIdentifierColumnNames(), session);
        }
        return resultset;
    }

    private boolean isAllNull(Object[] array, int tableNumber) {
        for (int i = 0; i < array.length; ++i) {
            if (!this.isPropertyOfTable(i, tableNumber) || array[i] == null) continue;
            return false;
        }
        return true;
    }

    public void delete(Serializable id, Object version, Object object, SessionImplementor session) throws HibernateException {
        int span = this.getTableSpan();
        if (span > 1) {
            throw new HibernateException("Hibernate OGM does not yet support entities spanning multiple tables");
        }
        EntityKey key = EntityKeyBuilder.fromPersister(this, id, session);
        Object[] loadedState = this.getLoadedState(id, session);
        Tuple currentState = null;
        if (this.mightRequireInverseAssociationManagement || this.usesNonAtomicOptimisticLocking) {
            currentState = this.gridDialect.getTuple(key, this.getTupleContext());
        }
        if (this.usesNonAtomicOptimisticLocking) {
            this.checkOptimisticLockingState(id, key, object, loadedState, version, session, currentState);
        }
        for (int j = span - 1; j >= 0; --j) {
            if (this.isInverseTable(j)) {
                return;
            }
            if (log.isTraceEnabled()) {
                log.trace("Deleting entity: " + MessageHelper.infoString((EntityPersister)this, (Object)id, (SessionFactoryImplementor)this.getFactory()));
                if (j == 0 && this.isVersioned()) {
                    log.trace("Version: " + version);
                }
            }
            if (this.mightRequireInverseAssociationManagement) {
                new EntityAssociationUpdater(this).id(id).resultset(currentState).session(session).tableIndex(j).propertyMightRequireInverseAssociationManagement(this.propertyMightRequireInverseAssociationManagement).removeNavigationalInformationFromInverseSide();
            }
            if (this.optimisticLockingAwareGridDialect != null && this.isVersioned()) {
                Tuple versionTuple = new Tuple();
                versionTuple.put(this.getVersionColumnName(), version);
                boolean success = this.optimisticLockingAwareGridDialect.removeTupleWithOptimisticLock(key, versionTuple, this.getTupleContext());
                if (success) continue;
                this.raiseStaleObjectStateException(id);
                continue;
            }
            this.gridDialect.removeTuple(key, this.getTupleContext());
        }
    }

    private Object[] getLoadedState(Serializable id, SessionImplementor session) {
        org.hibernate.engine.spi.EntityKey key = session.generateEntityKey(id, (EntityPersister)this);
        Object entity = session.getPersistenceContext().getEntity(key);
        if (entity != null) {
            EntityEntry entry = session.getPersistenceContext().getEntry(entity);
            return entry.getLoadedState();
        }
        return null;
    }

    private void checkOptimisticLockingState(Serializable id, EntityKey key, Object object, Object[] loadedState, Object version, SessionImplementor session, Tuple resultset) {
        boolean isImpliedOptimisticLocking;
        int tableSpan = this.getTableSpan();
        EntityMetamodel entityMetamodel = this.getEntityMetamodel();
        boolean bl = isImpliedOptimisticLocking = !entityMetamodel.isVersioned() && this.isAllOrDirtyOptLocking();
        if (isImpliedOptimisticLocking && loadedState != null) {
            for (int j = tableSpan - 1; j >= 0; --j) {
                boolean[] versionability = this.getPropertyVersionability();
                GridType[] types = this.gridPropertyTypes;
                for (int i = 0; i < entityMetamodel.getPropertySpan(); ++i) {
                    Object snapshotValue;
                    GridType type;
                    boolean include;
                    boolean bl2 = include = this.isPropertyOfTable(i, j) && versionability[i];
                    if (!include || (type = types[i]).isEqual(loadedState[i], snapshotValue = type.nullSafeGet(resultset, this.getPropertyColumnNames(i), session, object), this.getFactory())) continue;
                    this.raiseStaleObjectStateException(id);
                }
            }
        } else if (entityMetamodel.isVersioned()) {
            this.checkVersionAndRaiseSOSE(id, version, session, resultset);
        }
    }

    protected int[] getSubclassColumnTableNumberClosure() {
        return new int[this.getSubclassColumnClosure().length];
    }

    protected int[] getSubclassFormulaTableNumberClosure() {
        return new int[this.getSubclassFormulaClosure().length];
    }

    public String getDiscriminatorSQLValue() {
        return this.discriminator.getSqlValue();
    }

    public String[] getConstraintOrderedTableNameClosure() {
        return this.constraintOrderedTableNames;
    }

    public String[][] getContraintOrderedTableKeyColumnClosure() {
        return this.constraintOrderedKeyColumnNames;
    }

    public String getSubclassTableName(int j) {
        if (j != 0) {
            throw new AssertionFailure("only one table");
        }
        return this.tableName;
    }

    protected String[] getSubclassTableKeyColumns(int j) {
        if (j != 0) {
            throw new AssertionFailure("only one table");
        }
        return this.getIdentifierColumnNames();
    }

    protected boolean isClassOrSuperclassTable(int j) {
        if (j != 0) {
            throw new AssertionFailure("only one table");
        }
        return true;
    }

    protected int getSubclassTableSpan() {
        return 1;
    }

    protected int getTableSpan() {
        return 1;
    }

    protected boolean isTableCascadeDeleteEnabled(int j) {
        return false;
    }

    protected String getTableName(int j) {
        return this.tableName;
    }

    protected String[] getKeyColumns(int j) {
        return this.getIdentifierColumnNames();
    }

    protected boolean isPropertyOfTable(int property, int j) {
        return true;
    }

    protected int[] getPropertyTableNumbersInSelect() {
        return new int[this.getPropertySpan()];
    }

    protected int[] getPropertyTableNumbers() {
        return new int[this.getPropertySpan()];
    }

    protected int getSubclassPropertyTableNumber(int i) {
        return 0;
    }

    protected String filterFragment(String alias) throws MappingException {
        return "";
    }

    protected boolean[][] getPropertyColumnInsertable() {
        return super.getPropertyColumnInsertable();
    }

    protected GridType[] getGridPropertyTypes() {
        return this.gridPropertyTypes;
    }

    public String getSubclassPropertyTableName(int i) {
        return this.getTableName();
    }

    public String fromTableFragment(String alias) {
        return this.getTableName() + ' ' + alias;
    }

    public String getPropertyTableName(String propertyName) {
        return this.getTableName();
    }

    public String getTableName() {
        return this.tableName;
    }

    public Type getDiscriminatorType() {
        return IntegerType.INSTANCE;
    }

    public Object getDiscriminatorValue() {
        return this.discriminator.getValue();
    }

    public String getSubclassForDiscriminatorValue(Object value) {
        return this.discriminator.provideClassByValue(value);
    }

    public Serializable[] getPropertySpaces() {
        return this.spaces;
    }

    public TupleContext getTupleContext() {
        return this.tupleContext;
    }

    public String getJpaEntityName() {
        return this.jpaEntityName;
    }

    public void processInsertGeneratedProperties(Serializable id, Object entity, Object[] state, SessionImplementor session) {
        if (!this.hasUpdateGeneratedProperties()) {
            throw new AssertionFailure("no insert-generated properties");
        }
        this.processGeneratedProperties(id, entity, state, session, GenerationTiming.INSERT);
    }

    public void processUpdateGeneratedProperties(Serializable id, Object entity, Object[] state, SessionImplementor session) {
        if (!this.hasUpdateGeneratedProperties()) {
            throw new AssertionFailure("no update-generated properties");
        }
        this.processGeneratedProperties(id, entity, state, session, GenerationTiming.ALWAYS);
    }

    public AssociationKeyMetadata getInverseOneToOneAssociationKeyMetadata(String propertyName) {
        return this.inverseOneToOneAssociationKeyMetadata.get(propertyName);
    }

    private void processGeneratedProperties(Serializable id, Object entity, Object[] state, SessionImplementor session, GenerationTiming matchTiming) {
        Tuple tuple = this.getResultsetById(id, session);
        if (tuple == null || tuple.getSnapshot().isEmpty()) {
            throw log.couldNotRetrieveEntityForRetrievalOfGeneratedProperties(this.getEntityName(), id);
        }
        int propertyIndex = -1;
        for (NonIdentifierAttribute attribute : this.getEntityMetamodel().getProperties()) {
            ++propertyIndex;
            ValueGeneration valueGeneration = attribute.getValueGenerationStrategy();
            if (!this.isReadRequired(valueGeneration, matchTiming)) continue;
            Object hydratedState = this.gridPropertyTypes[propertyIndex].hydrate(tuple, this.getPropertyAliases("", propertyIndex), session, entity);
            state[propertyIndex] = this.gridPropertyTypes[propertyIndex].resolve(hydratedState, session, entity);
            this.setPropertyValue(entity, propertyIndex, state[propertyIndex]);
        }
    }

    private boolean isReadRequired(ValueGeneration valueGeneration, GenerationTiming matchTiming) {
        return valueGeneration != null && valueGeneration.getValueGenerator() == null && this.timingsMatch(valueGeneration.getGenerationTiming(), matchTiming);
    }

    private boolean timingsMatch(GenerationTiming timing, GenerationTiming matchTiming) {
        return matchTiming == GenerationTiming.INSERT && timing.includesInsert() || matchTiming == GenerationTiming.ALWAYS && timing.includesUpdate();
    }

    private String[] buildRowKeyColumnNamesForStarToOne(OgmEntityPersister persister, String[] keyColumnNames) {
        String[] identifierColumnNames = persister.getIdentifierColumnNames();
        int length = identifierColumnNames.length + keyColumnNames.length;
        String[] rowKeyColumnNames = new String[length];
        System.arraycopy(identifierColumnNames, 0, rowKeyColumnNames, 0, identifierColumnNames.length);
        System.arraycopy(keyColumnNames, 0, rowKeyColumnNames, identifierColumnNames.length, keyColumnNames.length);
        return rowKeyColumnNames;
    }

    private void raiseStaleObjectStateException(Serializable id) {
        SessionFactoryImplementor factory = this.getFactory();
        if (factory.getStatistics().isStatisticsEnabled()) {
            factory.getStatisticsImplementor().optimisticFailure(this.getEntityName());
        }
        throw new StaleObjectStateException(this.getEntityName(), id);
    }
}

