/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.ogm.util.configurationreader.impl;

import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Arrays;
import java.util.Locale;
import java.util.Map;
import org.hibernate.boot.registry.classloading.spi.ClassLoaderService;
import org.hibernate.ogm.util.configurationreader.impl.PropertyReaderContextBase;
import org.hibernate.ogm.util.impl.Log;
import org.hibernate.ogm.util.impl.LoggerFactory;
import org.hibernate.ogm.util.impl.StringHelper;

public class SimplePropertyReaderContext<T>
extends PropertyReaderContextBase<T> {
    private static final Log log = LoggerFactory.make();

    public SimplePropertyReaderContext(ClassLoaderService classLoaderService, Map<?, ?> configurationValues, String propertyName, Class<T> clazz) {
        super(classLoaderService, configurationValues.get(propertyName), propertyName, clazz);
    }

    @Override
    protected T getTypedValue() {
        Object typedValue = null;
        Class targetType = this.getTargetType();
        if (targetType == String.class) {
            typedValue = this.getAsString();
        } else if (targetType == Boolean.TYPE) {
            typedValue = this.getAsBoolean();
        } else if (targetType == Integer.TYPE) {
            typedValue = this.getAsInt();
        } else if (targetType.isEnum()) {
            typedValue = this.getAsEnum();
        } else if (targetType == URL.class) {
            typedValue = this.getAsUrl();
        } else {
            throw log.unsupportedPropertyType(this.getPropertyName(), this.getConfiguredValue().toString());
        }
        return (T)typedValue;
    }

    private String getAsString() {
        String stringValue = StringHelper.isNullOrEmptyString(this.getConfiguredValue()) ? null : this.getConfiguredValue().toString().trim();
        return stringValue == null ? (String)this.getDefaultValue() : stringValue;
    }

    private Boolean getAsBoolean() {
        Object configuredValue = this.getConfiguredValue();
        if (StringHelper.isNullOrEmptyString(configuredValue)) {
            return this.getDefaultValue() != null ? (Boolean)this.getDefaultValue() : false;
        }
        return configuredValue instanceof Boolean ? (Boolean)configuredValue : Boolean.valueOf(configuredValue.toString().trim());
    }

    private Integer getAsInt() {
        Object configuredValue = this.getConfiguredValue();
        if (StringHelper.isNullOrEmptyString(configuredValue)) {
            return this.getDefaultValue() != null ? (Integer)this.getDefaultValue() : 0;
        }
        if (configuredValue instanceof Number) {
            return ((Number)configuredValue).intValue();
        }
        try {
            String stringValue = configuredValue.toString().trim();
            return Integer.valueOf(stringValue);
        }
        catch (NumberFormatException e) {
            throw log.notAnInteger(this.getPropertyName(), configuredValue.toString());
        }
    }

    private <E extends Enum<E>> E getAsEnum() {
        Object configuredValue = this.getConfiguredValue();
        Class targetType = this.getTargetType();
        if (StringHelper.isNullOrEmptyString(configuredValue)) {
            return (E)((Enum)this.getDefaultValue());
        }
        if (configuredValue.getClass() == targetType) {
            Enum asEnum = (Enum)configuredValue;
            return (E)asEnum;
        }
        try {
            String stringValue = configuredValue.toString().trim().toUpperCase(Locale.ENGLISH);
            return (E)Enum.valueOf(targetType, stringValue);
        }
        catch (IllegalArgumentException e) {
            throw log.unknownEnumerationValue(this.getPropertyName(), configuredValue.toString(), Arrays.toString(targetType.getEnumConstants()));
        }
    }

    private URL getAsUrl() {
        Object configuredValue = this.getConfiguredValue();
        if (StringHelper.isNullOrEmptyString(configuredValue)) {
            return (URL)this.getDefaultValue();
        }
        if (configuredValue instanceof URL) {
            return (URL)configuredValue;
        }
        String stringValue = configuredValue.toString().trim();
        URL resource = this.getFromClassPath(stringValue);
        if (resource == null) {
            resource = this.getFromStringUrl(stringValue);
        }
        if (resource == null) {
            resource = this.getFromFileSystemPath(stringValue);
        }
        if (resource == null) {
            throw log.invalidConfigurationUrl(this.getPropertyName(), configuredValue.toString());
        }
        return resource;
    }

    private URL getFromFileSystemPath(String stringValue) {
        File file = new File(stringValue);
        if (!file.exists()) {
            return null;
        }
        try {
            return file.toURI().toURL();
        }
        catch (MalformedURLException e) {
            return null;
        }
    }

    private URL getFromClassPath(String stringValue) {
        return Thread.currentThread().getContextClassLoader().getResource(stringValue);
    }

    private URL getFromStringUrl(String stringValue) {
        try {
            return new URL(stringValue);
        }
        catch (MalformedURLException e) {
            return null;
        }
    }
}

