/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.ogm.util.impl;

import java.lang.reflect.Array;
import java.util.Collection;

public class ArrayHelper {
    public static final int[] EMPTY_INT_ARRAY = new int[0];
    public static final String[] EMPTY_STRING_ARRAY = new String[0];
    public static final Object[] EMPTY_OBJECT_ARRAY = new Object[0];

    public static String[] toStringArray(Collection coll) {
        return coll.toArray(new String[coll.size()]);
    }

    public static String[][] to2DStringArray(Collection coll) {
        return (String[][])coll.toArray((T[])new String[coll.size()][]);
    }

    public static String[] slice(String[] strings, int begin, int length) {
        String[] result = new String[length];
        System.arraycopy(strings, begin, result, 0, length);
        return result;
    }

    public static <T> int indexOf(T[] array, T element) {
        for (int i = 0; i < array.length; ++i) {
            if (!array[i].equals(element)) continue;
            return i;
        }
        return -1;
    }

    public static boolean contains(Object[] array, Object element) {
        return ArrayHelper.indexOf(array, element) != -1;
    }

    public static <T> T[] concat(T[] first, T ... second) {
        int firstLength = first.length;
        int secondLength = second.length;
        Object[] result = (Object[])Array.newInstance(first.getClass().getComponentType(), firstLength + secondLength);
        System.arraycopy(first, 0, result, 0, firstLength);
        System.arraycopy(second, 0, result, firstLength, secondLength);
        return result;
    }
}

