/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.ogm.datastore.mongodb.query.parsing.impl;

import java.util.Map;
import org.hibernate.SessionFactory;
import org.hibernate.engine.spi.SessionFactoryImplementor;
import org.hibernate.hql.QueryParser;
import org.hibernate.hql.ast.spi.AstProcessingChain;
import org.hibernate.hql.ast.spi.EntityNamesResolver;
import org.hibernate.ogm.datastore.mongodb.logging.impl.Log;
import org.hibernate.ogm.datastore.mongodb.logging.impl.LoggerFactory;
import org.hibernate.ogm.datastore.mongodb.query.parsing.impl.MongoDBProcessingChain;
import org.hibernate.ogm.datastore.mongodb.query.parsing.impl.MongoDBQueryParsingResult;
import org.hibernate.ogm.query.spi.BaseQueryParserService;
import org.hibernate.ogm.query.spi.QueryParsingResult;
import org.hibernate.ogm.service.impl.SessionFactoryEntityNamesResolver;

public class MongoDBBasedQueryParserService
extends BaseQueryParserService {
    private static final Log log = LoggerFactory.getLogger();
    private volatile SessionFactoryEntityNamesResolver entityNamesResolver;

    public QueryParsingResult parseQuery(SessionFactoryImplementor sessionFactory, String queryString, Map<String, Object> namedParameters) {
        QueryParser queryParser = new QueryParser();
        MongoDBProcessingChain processingChain = this.createProcessingChain(sessionFactory, this.unwrap(namedParameters));
        MongoDBQueryParsingResult result = (MongoDBQueryParsingResult)queryParser.parseQuery(queryString, (AstProcessingChain)processingChain);
        log.createdQuery(queryString, result);
        return result;
    }

    public QueryParsingResult parseQuery(SessionFactoryImplementor sessionFactory, String queryString) {
        throw new UnsupportedOperationException("MongoDB does not support parameterized queries. Parameter values must be passed to the query parser.");
    }

    public boolean supportsParameters() {
        return false;
    }

    private MongoDBProcessingChain createProcessingChain(SessionFactoryImplementor sessionFactory, Map<String, Object> namedParameters) {
        EntityNamesResolver entityNamesResolver = this.getDefinedEntityNames((SessionFactory)sessionFactory);
        return new MongoDBProcessingChain(sessionFactory, entityNamesResolver, namedParameters);
    }

    private EntityNamesResolver getDefinedEntityNames(SessionFactory sessionFactory) {
        if (this.entityNamesResolver == null) {
            this.entityNamesResolver = new SessionFactoryEntityNamesResolver(sessionFactory);
        }
        return this.entityNamesResolver;
    }
}

