/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.ogm.datastore.couchdb.dialect.backend.json.impl;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import java.util.Map;
import org.hibernate.ogm.datastore.couchdb.dialect.backend.json.impl.Document;
import org.hibernate.ogm.util.impl.CollectionHelper;

@JsonSerialize(include=JsonSerialize.Inclusion.NON_NULL)
@JsonTypeName(value="sequence")
public class SequenceDocument
extends Document {
    public static final String TYPE_NAME = "sequence";
    private final Map<String, Object> properties = CollectionHelper.newHashMap((int)1);
    private String valueProperty;

    SequenceDocument() {
    }

    public SequenceDocument(String valueProperty, long initialValue) {
        this.valueProperty = valueProperty;
        this.properties.put(valueProperty, String.valueOf(initialValue));
    }

    @JsonIgnore
    public long getValue() {
        return Long.valueOf((String)this.properties.get(this.valueProperty));
    }

    public void increase(int increment) {
        long value = this.getValue() + (long)increment;
        this.properties.put(this.valueProperty, String.valueOf(value));
    }

    @JsonAnyGetter
    Map<String, Object> getProperties() {
        return this.properties;
    }

    @JsonAnySetter
    void set(String name, Object value) {
        if (this.valueProperty == null) {
            this.valueProperty = name;
        }
        this.properties.put(name, value);
    }
}

