/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.backend.impl.lucene;

import java.util.Collections;
import java.util.Iterator;
import org.hibernate.search.backend.LuceneWork;
import org.hibernate.search.backend.impl.lucene.Changeset;

final class ChangesetList
implements Iterable<LuceneWork> {
    private final Iterable<Changeset> changesets;

    ChangesetList(Iterable<Changeset> changesets) {
        this.changesets = changesets;
    }

    void markProcessed() {
        for (Changeset changeset : this.changesets) {
            changeset.markProcessed();
        }
    }

    @Override
    public Iterator<LuceneWork> iterator() {
        return new WorkIterator(this.changesets.iterator());
    }

    private static class WorkIterator
    implements Iterator<LuceneWork> {
        private Iterator<Changeset> outerIterator;
        private Iterator<LuceneWork> current = Collections.emptyIterator();

        public WorkIterator(Iterator<Changeset> iterator) {
            this.outerIterator = iterator;
        }

        @Override
        public boolean hasNext() {
            return this.current.hasNext() || this.outerIterator.hasNext();
        }

        @Override
        public LuceneWork next() {
            if (this.current.hasNext()) {
                return this.current.next();
            }
            Changeset next = this.outerIterator.next();
            this.current = next.getWorkListIterator();
            return this.current.next();
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException("This iterator is unable to remove elements");
        }
    }
}

