/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.ogm.datastore.couchdb.dialect.model.impl;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.hibernate.ogm.datastore.couchdb.dialect.backend.json.impl.Document;
import org.hibernate.ogm.datastore.couchdb.dialect.backend.json.impl.EntityDocument;
import org.hibernate.ogm.datastore.couchdb.dialect.model.impl.CouchDBAssociation;
import org.hibernate.ogm.model.key.spi.AssociationKeyMetadata;

class EmbeddedAssociation
extends CouchDBAssociation {
    private final EntityDocument entity;
    private final AssociationKeyMetadata associationKeyMetadata;

    public EmbeddedAssociation(EntityDocument entity, AssociationKeyMetadata associationKeyMetadata) {
        this.entity = entity;
        this.associationKeyMetadata = associationKeyMetadata;
    }

    @Override
    public List<Object> getRows() {
        ArrayList<Object> rows;
        Object fieldValue = this.entity.getProperties().get(this.associationKeyMetadata.getCollectionRole());
        if (fieldValue == null) {
            rows = Collections.emptyList();
        } else if (this.associationKeyMetadata.isOneToOne()) {
            rows = new ArrayList<Object>(1);
            rows.add(fieldValue);
        } else {
            rows = (ArrayList<Object>)fieldValue;
        }
        return rows;
    }

    @Override
    public void setRows(List<Object> rows) {
        if (rows.isEmpty()) {
            this.entity.removeAssociation(this.associationKeyMetadata.getCollectionRole());
        } else {
            List<Object> value = this.associationKeyMetadata.isOneToOne() ? rows.iterator().next() : rows;
            this.entity.set(this.associationKeyMetadata.getCollectionRole(), value);
        }
    }

    @Override
    public Document getOwningDocument() {
        return this.entity;
    }
}

