/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.ogm.datastore.neo4j.query.parsing.impl;

import java.util.List;
import org.hibernate.engine.spi.SessionFactoryImplementor;
import org.hibernate.hql.ast.spi.EntityNamesResolver;
import org.hibernate.hql.ast.spi.PropertyHelper;
import org.hibernate.ogm.model.spi.Tuple;
import org.hibernate.ogm.persister.impl.OgmEntityPersister;
import org.hibernate.ogm.type.spi.GridType;
import org.hibernate.ogm.type.spi.TypeTranslator;
import org.hibernate.type.AbstractStandardBasicType;
import org.hibernate.type.ComponentType;
import org.hibernate.type.Type;

public class Neo4jPropertyHelper
implements PropertyHelper {
    private final SessionFactoryImplementor sessionFactory;
    private final EntityNamesResolver entityNames;

    public Neo4jPropertyHelper(SessionFactoryImplementor sessionFactory, EntityNamesResolver entityNames) {
        this.sessionFactory = sessionFactory;
        this.entityNames = entityNames;
    }

    public Object convertToPropertyType(String entityType, List<String> propertyPath, String value) {
        Type propertyType = this.getPropertyType(entityType, propertyPath);
        if (propertyType.isEntityType()) {
            throw new UnsupportedOperationException("Queries on associated entities are not supported yet.");
        }
        if (propertyType instanceof AbstractStandardBasicType) {
            return ((AbstractStandardBasicType)propertyType).fromString(value);
        }
        return value;
    }

    private Type getPropertyType(String entityType, List<String> propertyPath) {
        OgmEntityPersister persister = this.getPersister(entityType);
        String propertyName = propertyPath.get(0);
        Type propertyType = persister.getPropertyType(propertyName);
        if (propertyPath.size() == 1) {
            return propertyType;
        }
        if (propertyType.isComponentType()) {
            return this.embeddedPropertyType(propertyPath, (ComponentType)propertyType);
        }
        throw new UnsupportedOperationException("Queries on associated entities are not supported yet.");
    }

    private Type embeddedPropertyType(List<String> propertyPath, ComponentType propertyType) {
        ComponentType subType = propertyType;
        for (int i = 1; i < propertyPath.size(); ++i) {
            ComponentType componentType = subType;
            String name = propertyPath.get(i);
            int propertyIndex = componentType.getPropertyIndex(name);
            subType = componentType.getSubtypes()[propertyIndex];
            if (!subType.isAnyType() && !subType.isAssociationType() && !subType.isEntityType()) continue;
            throw new UnsupportedOperationException("Queries on associated entities are not supported yet.");
        }
        return subType;
    }

    public Object convertToLiteral(String entityType, List<String> propertyPath, Object value) {
        Type propertyType = this.getPropertyType(entityType, propertyPath);
        Object gridValue = this.convertToGridType(value, propertyType);
        return gridValue;
    }

    private Object convertToGridType(Object value, Type propertyType) {
        Tuple dummy = new Tuple();
        GridType gridType = this.typeTranslator().getType(propertyType);
        gridType.nullSafeSet(dummy, value, new String[]{"key"}, null);
        return dummy.get("key");
    }

    private TypeTranslator typeTranslator() {
        return (TypeTranslator)this.sessionFactory.getServiceRegistry().getService(TypeTranslator.class);
    }

    public String getColumnName(String entityType, String propertyName) {
        return this.getColumnName(this.getPersister(entityType), propertyName);
    }

    public String getColumnName(Class<?> entityType, String propertyName) {
        return this.getColumnName((OgmEntityPersister)this.sessionFactory.getEntityPersister(entityType.getName()), propertyName);
    }

    public String getColumnName(OgmEntityPersister persister, String propertyName) {
        String[] columnNames = persister.getPropertyColumnNames(propertyName);
        String columnName = columnNames[0];
        return columnName;
    }

    public String getEmbeddeColumnName(String entityType, String propertyPath) {
        String columnName = this.getColumnName(entityType, propertyPath);
        columnName = columnName.substring(columnName.lastIndexOf(46) + 1, columnName.length());
        return columnName;
    }

    private OgmEntityPersister getPersister(String entityType) {
        Class targetedType = this.entityNames.getClassFromName(entityType);
        if (targetedType == null) {
            throw new IllegalStateException("Unknown entity name " + entityType);
        }
        return (OgmEntityPersister)this.sessionFactory.getEntityPersister(targetedType.getName());
    }

    public boolean isEmbedddedProperty(String targetTypeName, List<String> namesWithoutAlias) {
        OgmEntityPersister persister = this.getPersister(targetTypeName);
        Type propertyType = persister.getPropertyType(namesWithoutAlias.get(0));
        return propertyType.isComponentType() && !propertyType.isAssociationType();
    }
}

