/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.ogm.datastore.neo4j.query.parsing.impl;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.antlr.runtime.tree.Tree;
import org.hibernate.hql.ast.common.JoinType;
import org.hibernate.hql.ast.origin.hql.resolve.path.PathedPropertyReference;
import org.hibernate.hql.ast.origin.hql.resolve.path.PathedPropertyReferenceSource;
import org.hibernate.hql.ast.origin.hql.resolve.path.PropertyPath;
import org.hibernate.hql.ast.spi.QueryResolverDelegate;
import org.hibernate.ogm.datastore.neo4j.query.parsing.impl.EmbeddedAliasTree;

public class Neo4jQueryResolverDelegate
implements QueryResolverDelegate {
    private final Map<String, String> aliasToEntityType = new HashMap<String, String>();
    private final Map<String, String> aliases = new HashMap<String, String>();
    private final Map<String, EmbeddedAliasTree> embeddedAliases = new HashMap<String, EmbeddedAliasTree>();
    private int embeddedCounter = 0;

    public void registerPersisterSpace(Tree entityName, Tree alias) {
        this.aliases.put(entityName.getText(), alias.getText());
        String put = this.aliasToEntityType.put(alias.getText(), entityName.getText());
        if (put != null && !put.equalsIgnoreCase(entityName.getText())) {
            throw new UnsupportedOperationException("Alias reuse currently not supported: alias " + alias.getText() + " already assigned to type " + put);
        }
    }

    public boolean isUnqualifiedPropertyReference() {
        return true;
    }

    public PathedPropertyReferenceSource normalizeUnqualifiedPropertyReference(Tree property) {
        if (this.aliasToEntityType.containsKey(property.getText())) {
            return new PathedPropertyReference(property.getText(), null, true);
        }
        return new PathedPropertyReference(property.getText(), null, false);
    }

    public boolean isPersisterReferenceAlias() {
        return true;
    }

    public PathedPropertyReferenceSource normalizeUnqualifiedRoot(Tree identifier382) {
        throw new UnsupportedOperationException("Not implemented yet");
    }

    public PathedPropertyReferenceSource normalizeQualifiedRoot(Tree identifier381) {
        return new PathedPropertyReference(identifier381.getText(), null, true);
    }

    public PathedPropertyReferenceSource normalizePropertyPathIntermediary(PropertyPath path, Tree propertyName) {
        return new PathedPropertyReference(propertyName.getText(), null, false);
    }

    public PathedPropertyReferenceSource normalizeIntermediateIndexOperation(PathedPropertyReferenceSource propertyReferenceSource, Tree collectionProperty, Tree selector) {
        throw new UnsupportedOperationException("Not implemented yet");
    }

    public void normalizeTerminalIndexOperation(PathedPropertyReferenceSource propertyReferenceSource, Tree collectionProperty, Tree selector) {
        throw new UnsupportedOperationException("Not implemented yet");
    }

    public PathedPropertyReferenceSource normalizeUnqualifiedPropertyReferenceSource(Tree identifier394) {
        throw new UnsupportedOperationException("Not implemented yet");
    }

    public PathedPropertyReferenceSource normalizePropertyPathTerminus(PropertyPath path, Tree propertyNameNode) {
        return new PathedPropertyReference(propertyNameNode.getText(), null, false);
    }

    public void pushFromStrategy(JoinType joinType, Tree assosiationFetchTree, Tree propertyFetchTree, Tree alias) {
        throw new UnsupportedOperationException("Not implemented yet");
    }

    public void pushSelectStrategy() {
    }

    public void popStrategy() {
    }

    public void propertyPathCompleted(PropertyPath path) {
    }

    public String findAliasForType(String entityType) {
        return this.aliases.get(entityType);
    }

    public String createAliasForEmbedded(String entityAlias, List<String> propertyPathWithoutAlias) {
        EmbeddedAliasTree embeddedAlias = this.embeddedAliases.get(entityAlias);
        if (embeddedAlias == null) {
            embeddedAlias = new EmbeddedAliasTree(entityAlias, entityAlias);
            this.embeddedAliases.put(entityAlias, embeddedAlias);
        }
        for (int i = 0; i < propertyPathWithoutAlias.size() - 1; ++i) {
            String name = propertyPathWithoutAlias.get(i);
            EmbeddedAliasTree child = embeddedAlias.findChild(name);
            if (child == null) {
                ++this.embeddedCounter;
                String childAlias = "_" + entityAlias + this.embeddedCounter;
                child = new EmbeddedAliasTree(childAlias, name);
                embeddedAlias.addChild(child);
            }
            embeddedAlias = child;
        }
        return embeddedAlias.getAlias();
    }

    public String findAliasForEmbedded(String entityAlias, List<String> propertyPathWithoutAlias) {
        EmbeddedAliasTree aliasTree = this.embeddedAliases.get(entityAlias);
        if (aliasTree == null) {
            return null;
        }
        EmbeddedAliasTree embedded = aliasTree;
        for (int i = 0; i < propertyPathWithoutAlias.size() - 1; ++i) {
            if ((embedded = embedded.findChild(propertyPathWithoutAlias.get(i))) != null) continue;
            return null;
        }
        return embedded.getAlias();
    }

    public EmbeddedAliasTree getAliasTree(String entityAlias) {
        return this.embeddedAliases.get(entityAlias);
    }
}

