/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.api.properties;

import org.neo4j.kernel.api.properties.IntegralArrayProperty;
import org.neo4j.kernel.impl.cache.SizeOfs;

class ShortArrayProperty
extends IntegralArrayProperty {
    private final short[] value;

    ShortArrayProperty(int propertyKeyId, short[] value) {
        super(propertyKeyId);
        assert (value != null);
        this.value = value;
    }

    public short[] value() {
        return (short[])this.value.clone();
    }

    @Override
    public int length() {
        return this.value.length;
    }

    @Override
    public long longValue(int index) {
        return this.value[index];
    }

    @Override
    public int sizeOfObjectInBytesIncludingOverhead() {
        return SizeOfs.withObjectOverhead(SizeOfs.withReference(SizeOfs.sizeOfArray(this.value)));
    }
}

