/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.collection.primitive.hopscotch;

import java.util.Arrays;
import org.neo4j.collection.primitive.hopscotch.IntArrayBasedKeyTable;

public class LongKeyTable<VALUE>
extends IntArrayBasedKeyTable<VALUE> {
    public LongKeyTable(int capacity, VALUE singleValue) {
        super(capacity, 3, 32, singleValue);
    }

    @Override
    public long key(int index) {
        int actualIndex = this.index(index);
        long low = (long)this.table[actualIndex] & 0xFFFFFFFFL;
        long high = (long)this.table[actualIndex + 1] & 0xFFFFFFFFL;
        return high << 32 | low;
    }

    @Override
    protected void internalPut(int actualIndex, long key, VALUE value) {
        this.table[actualIndex] = (int)key;
        this.table[actualIndex + 1] = (int)((key & 0xFFFFFFFF00000000L) >>> 32);
    }

    @Override
    protected void internalRemove(int actualIndex) {
        Arrays.fill(this.table, actualIndex, actualIndex + 2, -1);
    }

    @Override
    protected LongKeyTable<VALUE> newInstance(int newCapacity) {
        return new LongKeyTable<Object>(newCapacity, this.singleValue);
    }
}

