/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.ogm.options.navigation.impl;

public class PropertyKey {
    private final Class<?> entity;
    private final String property;
    private final int hashCode;

    public PropertyKey(Class<?> entity, String property) {
        this.entity = entity;
        this.property = property;
        this.hashCode = this.computeHashCode(entity, property);
    }

    public Class<?> getEntity() {
        return this.entity;
    }

    public String getProperty() {
        return this.property;
    }

    public String toString() {
        return this.entity.getName() + "#" + this.property;
    }

    public int hashCode() {
        return this.hashCode;
    }

    private int computeHashCode(Class<?> entity, String property) {
        int prime = 31;
        int result = 1;
        result = 31 * result + (entity == null ? 0 : entity.hashCode());
        result = 31 * result + (property == null ? 0 : property.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        PropertyKey other = (PropertyKey)obj;
        if (this.entity == null ? other.entity != null : !this.entity.equals(other.entity)) {
            return false;
        }
        return !(this.property == null ? other.property != null : !this.property.equals(other.property));
    }
}

