/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.ogm.service.impl;

import org.hibernate.event.spi.AbstractEvent;
import org.hibernate.ogm.dialect.impl.BatchOperationsDelegator;
import org.hibernate.ogm.util.impl.Log;
import org.hibernate.ogm.util.impl.LoggerFactory;

abstract class BatchManagerEventListener<L, E extends AbstractEvent> {
    private static final Log log = LoggerFactory.make();
    private final BatchOperationsDelegator gridDialect;
    private L delegate;

    public BatchManagerEventListener(BatchOperationsDelegator gridDialect) {
        this.gridDialect = gridDialect;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void onEvent(E event) {
        try {
            log.tracef("%s %s", event.getClass(), " - begin");
            this.gridDialect.prepareBatch();
            this.delegate(this.delegate, event);
            this.gridDialect.executeBatch();
            log.tracef("%s %s", event.getClass(), " - end");
        }
        finally {
            this.gridDialect.clearBatch();
        }
    }

    abstract void delegate(L var1, E var2);

    public void setDelegate(L delegate) {
        this.delegate = delegate;
    }
}

