/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.api.impl.index;

import java.io.File;
import org.neo4j.graphdb.factory.GraphDatabaseSettings;
import org.neo4j.kernel.api.impl.index.DirectoryFactory;
import org.neo4j.kernel.api.impl.index.IndexWriterFactories;
import org.neo4j.kernel.api.impl.index.LuceneKernelExtensions;
import org.neo4j.kernel.api.impl.index.LuceneLabelScanStore;
import org.neo4j.kernel.api.impl.index.NodeRangeDocumentLabelScanStorageStrategy;
import org.neo4j.kernel.api.labelscan.LabelScanStore;
import org.neo4j.kernel.configuration.Config;
import org.neo4j.kernel.extension.KernelExtensionFactory;
import org.neo4j.kernel.impl.api.scan.LabelScanStoreProvider;
import org.neo4j.kernel.impl.nioneo.store.FileSystemAbstraction;
import org.neo4j.kernel.impl.nioneo.xa.NeoStoreProvider;
import org.neo4j.kernel.logging.Logging;

public class LuceneLabelScanStoreExtension
extends KernelExtensionFactory<Dependencies> {
    private final int priority;
    private final LuceneLabelScanStore.Monitor monitor;

    public LuceneLabelScanStoreExtension() {
        this(10, null);
    }

    LuceneLabelScanStoreExtension(int priority, LuceneLabelScanStore.Monitor monitor) {
        super("lucene");
        this.priority = priority;
        this.monitor = monitor;
    }

    public LabelScanStoreProvider newKernelExtension(Dependencies dependencies) throws Throwable {
        DirectoryFactory directoryFactory = LuceneKernelExtensions.directoryFactory(dependencies.getConfig(), dependencies.getFileSystem());
        File storeDir = (File)dependencies.getConfig().get(GraphDatabaseSettings.store_dir);
        LuceneLabelScanStore scanStore = new LuceneLabelScanStore(new NodeRangeDocumentLabelScanStorageStrategy(), directoryFactory, new File(new File(new File(storeDir, "schema"), "label"), "lucene"), dependencies.getFileSystem(), IndexWriterFactories.standard(), LabelScanStoreProvider.fullStoreLabelUpdateStream((NeoStoreProvider)dependencies.getNeoStoreProvider()), this.monitor != null ? this.monitor : LuceneLabelScanStore.loggerMonitor(dependencies.getLogging()));
        return new LabelScanStoreProvider((LabelScanStore)scanStore, this.priority);
    }

    public static interface Dependencies {
        public Config getConfig();

        public FileSystemAbstraction getFileSystem();

        public NeoStoreProvider getNeoStoreProvider();

        public Logging getLogging();
    }
}

