/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.interceptors.compat;

import java.util.Set;
import org.infinispan.commons.CacheException;
import org.infinispan.commons.marshall.Marshaller;
import org.infinispan.commons.util.ServiceFinder;
import org.infinispan.compat.TypeConverter;
import org.infinispan.context.Flag;
import org.infinispan.interceptors.compat.BaseTypeConverterInterceptor;

public class TypeConverterInterceptor
extends BaseTypeConverterInterceptor {
    private TypeConverter<Object, Object, Object, Object> hotRodConverter;
    private TypeConverter<Object, Object, Object, Object> memcachedConverter;
    private TypeConverter<Object, Object, Object, Object> embeddedConverter;

    public TypeConverterInterceptor(Marshaller marshaller) {
        Set converters = ServiceFinder.load(TypeConverter.class, (ClassLoader[])new ClassLoader[0]);
        for (TypeConverter converter : converters) {
            if (converter.supportsInvocation(Flag.OPERATION_HOTROD)) {
                this.hotRodConverter = this.setConverterMarshaller(converter, marshaller);
                continue;
            }
            if (!converter.supportsInvocation(Flag.OPERATION_MEMCACHED)) continue;
            this.memcachedConverter = this.setConverterMarshaller(converter, marshaller);
        }
        this.embeddedConverter = this.setConverterMarshaller(new EmbeddedTypeConverter(), marshaller);
    }

    private TypeConverter setConverterMarshaller(TypeConverter converter, Marshaller marshaller) {
        if (marshaller != null) {
            converter.setMarshaller(marshaller);
        }
        return converter;
    }

    @Override
    protected TypeConverter<Object, Object, Object, Object> determineTypeConverter(Set<Flag> flags) {
        if (flags != null) {
            if (flags.contains((Object)Flag.OPERATION_HOTROD)) {
                return this.hotRodConverter;
            }
            if (flags.contains((Object)Flag.OPERATION_MEMCACHED)) {
                return this.memcachedConverter;
            }
        }
        return this.embeddedConverter;
    }

    private static class EmbeddedTypeConverter
    implements TypeConverter<Object, Object, Object, Object> {
        private Marshaller marshaller;

        private EmbeddedTypeConverter() {
        }

        @Override
        public Object boxKey(Object key) {
            return key;
        }

        @Override
        public Object boxValue(Object value) {
            return value;
        }

        @Override
        public Object unboxKey(Object target) {
            return this.unboxValue(target);
        }

        @Override
        public Object unboxValue(Object target) {
            if (this.marshaller != null && target instanceof byte[]) {
                try {
                    return this.marshaller.objectFromByteBuffer((byte[])target);
                }
                catch (Exception e) {
                    throw new CacheException("Unable to unmarshall return value");
                }
            }
            return target;
        }

        @Override
        public boolean supportsInvocation(Flag flag) {
            return false;
        }

        @Override
        public void setMarshaller(Marshaller marshaller) {
            this.marshaller = marshaller;
        }
    }
}

