/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.jcajce;

import java.security.AlgorithmParameterGenerator;
import java.security.AlgorithmParameters;
import java.security.KeyFactory;
import java.security.KeyPairGenerator;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.PrivateKey;
import java.security.Signature;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import javax.crypto.Cipher;
import javax.crypto.KeyAgreement;
import javax.crypto.KeyGenerator;
import javax.crypto.Mac;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.SecretKey;
import org.bouncycastle.asn1.x509.AlgorithmIdentifier;
import org.bouncycastle.jcajce.JcaJceHelper;
import org.bouncycastle.operator.AsymmetricKeyUnwrapper;
import org.bouncycastle.operator.SymmetricKeyUnwrapper;
import org.bouncycastle.operator.jcajce.JceAsymmetricKeyUnwrapper;
import org.bouncycastle.operator.jcajce.JceSymmetricKeyUnwrapper;

public class NamedJcaJceHelper
implements JcaJceHelper {
    private final String providerName;

    public NamedJcaJceHelper(String string) {
        this.providerName = string;
    }

    @Override
    public Cipher createCipher(String string) throws NoSuchAlgorithmException, NoSuchPaddingException, NoSuchProviderException {
        return Cipher.getInstance(string, this.providerName);
    }

    @Override
    public Mac createMac(String string) throws NoSuchAlgorithmException, NoSuchProviderException {
        return Mac.getInstance(string, this.providerName);
    }

    @Override
    public KeyAgreement createKeyAgreement(String string) throws NoSuchAlgorithmException, NoSuchProviderException {
        return KeyAgreement.getInstance(string, this.providerName);
    }

    @Override
    public AlgorithmParameterGenerator createAlgorithmParameterGenerator(String string) throws NoSuchAlgorithmException, NoSuchProviderException {
        return AlgorithmParameterGenerator.getInstance(string, this.providerName);
    }

    @Override
    public AlgorithmParameters createAlgorithmParameters(String string) throws NoSuchAlgorithmException, NoSuchProviderException {
        return AlgorithmParameters.getInstance(string, this.providerName);
    }

    @Override
    public KeyGenerator createKeyGenerator(String string) throws NoSuchAlgorithmException, NoSuchProviderException {
        return KeyGenerator.getInstance(string, this.providerName);
    }

    @Override
    public KeyFactory createKeyFactory(String string) throws NoSuchAlgorithmException, NoSuchProviderException {
        return KeyFactory.getInstance(string, this.providerName);
    }

    @Override
    public KeyPairGenerator createKeyPairGenerator(String string) throws NoSuchAlgorithmException, NoSuchProviderException {
        return KeyPairGenerator.getInstance(string, this.providerName);
    }

    @Override
    public MessageDigest createDigest(String string) throws NoSuchAlgorithmException, NoSuchProviderException {
        return MessageDigest.getInstance(string, this.providerName);
    }

    @Override
    public Signature createSignature(String string) throws NoSuchAlgorithmException, NoSuchProviderException {
        return Signature.getInstance(string, this.providerName);
    }

    @Override
    public CertificateFactory createCertificateFactory(String string) throws NoSuchAlgorithmException, CertificateException, NoSuchProviderException {
        return CertificateFactory.getInstance(string, this.providerName);
    }

    @Override
    public AsymmetricKeyUnwrapper createAsymmetricUnwrapper(AlgorithmIdentifier algorithmIdentifier, PrivateKey privateKey) {
        return new JceAsymmetricKeyUnwrapper(algorithmIdentifier, privateKey).setProvider(this.providerName);
    }

    @Override
    public SymmetricKeyUnwrapper createSymmetricUnwrapper(AlgorithmIdentifier algorithmIdentifier, SecretKey secretKey) {
        return new JceSymmetricKeyUnwrapper(algorithmIdentifier, secretKey).setProvider(this.providerName);
    }
}

