/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.ogm.datastore.infinispan.persistencestrategy.table.impl;

import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.hibernate.engine.transaction.jta.platform.spi.JtaPlatform;
import org.hibernate.ogm.datastore.infinispan.persistencestrategy.impl.LocalCacheManager;
import org.hibernate.ogm.datastore.infinispan.persistencestrategy.table.externalizer.impl.PersistentAssociationKey;
import org.hibernate.ogm.datastore.infinispan.persistencestrategy.table.externalizer.impl.PersistentEntityKey;
import org.hibernate.ogm.datastore.infinispan.persistencestrategy.table.externalizer.impl.PersistentIdSourceKey;
import org.hibernate.ogm.datastore.infinispan.persistencestrategy.table.impl.PerTableKeyProvider;
import org.hibernate.ogm.model.key.spi.AssociationKeyMetadata;
import org.hibernate.ogm.model.key.spi.EntityKeyMetadata;
import org.hibernate.ogm.model.key.spi.IdSourceKeyMetadata;
import org.hibernate.ogm.model.key.spi.RowKey;
import org.hibernate.ogm.util.impl.CollectionHelper;
import org.infinispan.Cache;
import org.infinispan.manager.EmbeddedCacheManager;

public class PerTableCacheManager
extends LocalCacheManager<PersistentEntityKey, PersistentAssociationKey, PersistentIdSourceKey> {
    private static final String ASSOCIATIONS_CACHE_PREFIX = "associations_";
    private final ConcurrentMap<String, Cache<PersistentEntityKey, Map<String, Object>>> entityCaches;
    private final ConcurrentMap<String, Cache<PersistentAssociationKey, Map<RowKey, Map<String, Object>>>> associationCaches;
    private final ConcurrentMap<String, Cache<PersistentIdSourceKey, Object>> idSourceCaches;

    public PerTableCacheManager(EmbeddedCacheManager cacheManager, Set<EntityKeyMetadata> entityTypes, Set<AssociationKeyMetadata> associationTypes, Set<IdSourceKeyMetadata> idSourceTypes) {
        super(cacheManager);
        this.entityCaches = PerTableCacheManager.initializeEntityCaches(this.getCacheManager(), entityTypes);
        this.associationCaches = PerTableCacheManager.initializeAssociationCaches(this.getCacheManager(), associationTypes);
        this.idSourceCaches = PerTableCacheManager.initializeIdSourceCaches(this.getCacheManager(), idSourceTypes);
    }

    public PerTableCacheManager(URL configUrl, JtaPlatform platform, Set<EntityKeyMetadata> entityTypes, Set<AssociationKeyMetadata> associationTypes, Set<IdSourceKeyMetadata> idSourceTypes) {
        super(configUrl, platform, PerTableCacheManager.getCacheNames(entityTypes, associationTypes, idSourceTypes), new PerTableKeyProvider());
        this.entityCaches = PerTableCacheManager.initializeEntityCaches(this.getCacheManager(), entityTypes);
        this.associationCaches = PerTableCacheManager.initializeAssociationCaches(this.getCacheManager(), associationTypes);
        this.idSourceCaches = PerTableCacheManager.initializeIdSourceCaches(this.getCacheManager(), idSourceTypes);
    }

    private static Set<String> getCacheNames(Set<EntityKeyMetadata> entityTypes, Set<AssociationKeyMetadata> associationTypes, Set<IdSourceKeyMetadata> idSourceTypes) {
        HashSet<String> cacheNames = new HashSet<String>();
        for (EntityKeyMetadata entityKeyMetadata : entityTypes) {
            cacheNames.add(entityKeyMetadata.getTable());
        }
        for (AssociationKeyMetadata associationKeyMetadata : associationTypes) {
            cacheNames.add(PerTableCacheManager.getCacheName(associationKeyMetadata));
        }
        for (IdSourceKeyMetadata idSourceKeyMetadata : idSourceTypes) {
            cacheNames.add(idSourceKeyMetadata.getName());
        }
        return cacheNames;
    }

    private static ConcurrentMap<String, Cache<PersistentEntityKey, Map<String, Object>>> initializeEntityCaches(EmbeddedCacheManager embeddedCacheManager, Set<EntityKeyMetadata> entityTypes) {
        ConcurrentHashMap entityCaches = CollectionHelper.newConcurrentHashMap((int)entityTypes.size());
        for (EntityKeyMetadata entityKeyMetadata : entityTypes) {
            Cache entityCache = embeddedCacheManager.getCache(entityKeyMetadata.getTable());
            entityCaches.put(entityKeyMetadata.getTable(), entityCache);
        }
        return entityCaches;
    }

    private static ConcurrentMap<String, Cache<PersistentAssociationKey, Map<RowKey, Map<String, Object>>>> initializeAssociationCaches(EmbeddedCacheManager embeddedCacheManager, Set<AssociationKeyMetadata> associationTypes) {
        ConcurrentHashMap associationCaches = CollectionHelper.newConcurrentHashMap((int)associationTypes.size());
        for (AssociationKeyMetadata associationKeyMetadata : associationTypes) {
            String cacheName = PerTableCacheManager.getCacheName(associationKeyMetadata);
            associationCaches.put(cacheName, embeddedCacheManager.getCache(cacheName));
        }
        return associationCaches;
    }

    private static ConcurrentMap<String, Cache<PersistentIdSourceKey, Object>> initializeIdSourceCaches(EmbeddedCacheManager embeddedCacheManager, Set<IdSourceKeyMetadata> idSourceTypes) {
        ConcurrentHashMap idSourceCaches = CollectionHelper.newConcurrentHashMap((int)idSourceTypes.size());
        for (IdSourceKeyMetadata idSourceKeyMetadata : idSourceTypes) {
            if (idSourceCaches.containsKey(idSourceKeyMetadata.getName())) continue;
            Cache idSourceCache = embeddedCacheManager.getCache(idSourceKeyMetadata.getName());
            idSourceCaches.put(idSourceKeyMetadata.getName(), idSourceCache);
        }
        return idSourceCaches;
    }

    @Override
    public Cache<PersistentEntityKey, Map<String, Object>> getEntityCache(EntityKeyMetadata keyMetadata) {
        return (Cache)this.entityCaches.get(keyMetadata.getTable());
    }

    @Override
    public Cache<PersistentAssociationKey, Map<RowKey, Map<String, Object>>> getAssociationCache(AssociationKeyMetadata keyMetadata) {
        return (Cache)this.associationCaches.get(PerTableCacheManager.getCacheName(keyMetadata));
    }

    @Override
    public Cache<PersistentIdSourceKey, Object> getIdSourceCache(IdSourceKeyMetadata keyMetadata) {
        return (Cache)this.idSourceCaches.get(keyMetadata.getName());
    }

    @Override
    public Set<LocalCacheManager.Bucket<PersistentEntityKey>> getWorkBucketsFor(EntityKeyMetadata ... entityKeyMetadatas) {
        Map<String, List<EntityKeyMetadata>> metadataByTable = this.groupByTable(entityKeyMetadatas);
        HashSet<LocalCacheManager.Bucket<PersistentEntityKey>> result = new HashSet<LocalCacheManager.Bucket<PersistentEntityKey>>();
        for (Map.Entry<String, List<EntityKeyMetadata>> entry : metadataByTable.entrySet()) {
            result.add(new LocalCacheManager.Bucket((Cache)this.entityCaches.get(entry.getKey()), entry.getValue()));
        }
        return result;
    }

    private Map<String, List<EntityKeyMetadata>> groupByTable(EntityKeyMetadata ... entityKeyMetadatas) {
        HashMap metadataByTable = CollectionHelper.newHashMap();
        for (EntityKeyMetadata entityKeyMetadata : entityKeyMetadatas) {
            ArrayList<EntityKeyMetadata> metadataOfTable = (ArrayList<EntityKeyMetadata>)metadataByTable.get(entityKeyMetadata.getTable());
            if (metadataOfTable == null) {
                metadataOfTable = new ArrayList<EntityKeyMetadata>();
                metadataByTable.put(entityKeyMetadata.getTable(), metadataOfTable);
            }
            metadataOfTable.add(entityKeyMetadata);
        }
        return metadataByTable;
    }

    private static String getCacheName(AssociationKeyMetadata keyMetadata) {
        return ASSOCIATIONS_CACHE_PREFIX + keyMetadata.getTable();
    }
}

