/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.ogm.datastore.ehcache.impl;

import java.net.URL;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import javax.transaction.TransactionManager;
import net.sf.ehcache.CacheManager;
import net.sf.ehcache.config.Configuration;
import net.sf.ehcache.config.ConfigurationFactory;
import net.sf.ehcache.config.FactoryConfiguration;
import net.sf.ehcache.transaction.manager.TransactionManagerLookup;
import net.sf.ehcache.transaction.xa.EhcacheXAResource;
import org.hibernate.engine.transaction.jta.platform.spi.JtaPlatform;
import org.hibernate.ogm.datastore.ehcache.EhcacheDialect;
import org.hibernate.ogm.datastore.ehcache.configuration.impl.EhcacheConfiguration;
import org.hibernate.ogm.datastore.ehcache.impl.CacheInitializer;
import org.hibernate.ogm.datastore.ehcache.logging.impl.Log;
import org.hibernate.ogm.datastore.ehcache.logging.impl.LoggerFactory;
import org.hibernate.ogm.datastore.ehcache.persistencestrategy.impl.KeyProvider;
import org.hibernate.ogm.datastore.ehcache.persistencestrategy.impl.LocalCacheManager;
import org.hibernate.ogm.datastore.ehcache.persistencestrategy.impl.PersistenceStrategy;
import org.hibernate.ogm.datastore.keyvalue.options.CacheMappingType;
import org.hibernate.ogm.datastore.spi.BaseDatastoreProvider;
import org.hibernate.ogm.datastore.spi.SchemaDefiner;
import org.hibernate.ogm.dialect.spi.GridDialect;
import org.hibernate.ogm.model.key.spi.AssociationKeyMetadata;
import org.hibernate.ogm.model.key.spi.EntityKeyMetadata;
import org.hibernate.ogm.model.key.spi.IdSourceKeyMetadata;
import org.hibernate.service.spi.Configurable;
import org.hibernate.service.spi.ServiceRegistryAwareService;
import org.hibernate.service.spi.ServiceRegistryImplementor;
import org.hibernate.service.spi.Startable;
import org.hibernate.service.spi.Stoppable;

public class EhcacheDatastoreProvider
extends BaseDatastoreProvider
implements Startable,
Stoppable,
ServiceRegistryAwareService,
Configurable {
    private static final Log logger = LoggerFactory.getLogger();
    private JtaPlatform jtaPlatform;
    private CacheManager cacheManager;
    private final EhcacheConfiguration config = new EhcacheConfiguration();
    private PersistenceStrategy<?, ?, ?> persistenceStrategy;

    public void configure(Map map) {
        this.config.initialize(map);
    }

    public Class<? extends GridDialect> getDefaultDialect() {
        return EhcacheDialect.class;
    }

    public void injectServices(ServiceRegistryImplementor serviceRegistryImplementor) {
        this.jtaPlatform = (JtaPlatform)serviceRegistryImplementor.getService(JtaPlatform.class);
    }

    public void start() {
        try {
            Configuration configuration = ConfigurationFactory.parseConfiguration((URL)this.config.getUrl());
            if (this.jtaPlatform != null) {
                OgmTransactionManagerLookupDelegate.transactionManager = this.jtaPlatform.retrieveTransactionManager();
                FactoryConfiguration transactionManagerLookupParameter = new FactoryConfiguration();
                transactionManagerLookupParameter.setClass(OgmTransactionManagerLookupDelegate.class.getName());
                configuration.addTransactionManagerLookup(transactionManagerLookupParameter);
            }
            this.cacheManager = CacheManager.create((URL)this.config.getUrl());
        }
        catch (Exception e) {
            throw logger.unableToStartDatastoreProvider(e);
        }
    }

    public void initializePersistenceStrategy(CacheMappingType cacheMappingType, Set<EntityKeyMetadata> entityTypes, Set<AssociationKeyMetadata> associationTypes, Set<IdSourceKeyMetadata> idSourceTypes) {
        this.persistenceStrategy = PersistenceStrategy.getInstance(cacheMappingType, this.cacheManager, entityTypes, associationTypes, idSourceTypes);
        this.cacheManager = null;
        this.jtaPlatform = null;
    }

    public LocalCacheManager<?, ?, ?> getCacheManager() {
        return this.persistenceStrategy.getCacheManager();
    }

    public KeyProvider<?, ?, ?> getKeyProvider() {
        return this.persistenceStrategy.getKeyProvider();
    }

    public void stop() {
        if (this.persistenceStrategy != null) {
            this.persistenceStrategy.getCacheManager().stop();
        }
    }

    public Class<? extends SchemaDefiner> getSchemaDefinerType() {
        return CacheInitializer.class;
    }

    public static class OgmTransactionManagerLookupDelegate
    implements TransactionManagerLookup {
        private static TransactionManager transactionManager;

        public TransactionManager getTransactionManager() {
            return transactionManager;
        }

        public void init() {
        }

        public void register(EhcacheXAResource resource, boolean forRecovery) {
        }

        public void unregister(EhcacheXAResource resource, boolean forRecovery) {
        }

        public void setProperties(Properties properties) {
        }
    }
}

