/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.ogm.datastore.ehcache.persistencestrategy.kind.impl;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.Arrays;
import org.hibernate.ogm.datastore.ehcache.persistencestrategy.common.impl.VersionChecker;
import org.hibernate.ogm.model.key.spi.IdSourceKey;

public class SerializableIdSourceKey
implements Externalizable {
    private static final long serialVersionUID = 1L;
    private static final int VERSION = 1;
    private String table;
    private String[] columnNames;
    private Object[] columnValues;

    public SerializableIdSourceKey() {
    }

    SerializableIdSourceKey(IdSourceKey key) {
        this.columnNames = key.getColumnNames();
        this.columnValues = key.getColumnValues();
        this.table = key.getTable();
    }

    public String getTable() {
        return this.table;
    }

    public String[] getColumnNames() {
        return this.columnNames;
    }

    public Object[] getColumnValues() {
        return this.columnValues;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + Arrays.hashCode(this.columnNames);
        result = 31 * result + Arrays.hashCode(this.columnValues);
        result = 31 * result + (this.table == null ? 0 : this.table.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        SerializableIdSourceKey other = (SerializableIdSourceKey)obj;
        if (!Arrays.equals(this.columnNames, other.columnNames)) {
            return false;
        }
        if (!Arrays.equals(this.columnValues, other.columnValues)) {
            return false;
        }
        return !(this.table == null ? other.table != null : !this.table.equals(other.table));
    }

    public String toString() {
        return "SerializableIdSourceKey [table=" + this.table + ", columnNames=" + Arrays.toString(this.columnNames) + ", columnValues=" + Arrays.toString(this.columnValues) + "]";
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeInt(1);
        out.writeUTF(this.table);
        out.writeObject(this.columnNames);
        out.writeObject(this.columnValues);
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        VersionChecker.readAndCheckVersion(in, 1, SerializableIdSourceKey.class);
        this.table = in.readUTF();
        this.columnNames = (String[])in.readObject();
        this.columnValues = (Object[])in.readObject();
    }
}

