/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.api.index;

import org.neo4j.kernel.impl.api.index.IndexMap;
import org.neo4j.kernel.impl.api.index.IndexProxy;
import org.neo4j.kernel.impl.api.index.IndexUpdateMode;
import org.neo4j.kernel.impl.api.index.IndexUpdaterMap;

public class IndexMapReference {
    private volatile IndexMap indexMap = new IndexMap();

    public IndexMap getIndexMapCopy() {
        return this.indexMap.clone();
    }

    public IndexProxy getIndexProxy(long indexId) {
        return this.indexMap.getIndexProxy(indexId);
    }

    public Iterable<IndexProxy> getAllIndexProxies() {
        return this.indexMap.getAllIndexProxies();
    }

    public void setIndexMap(IndexMap newIndexMap) {
        this.indexMap = newIndexMap;
    }

    public IndexProxy removeIndexProxy(long indexId) {
        IndexMap newIndexMap = this.getIndexMapCopy();
        IndexProxy indexProxy = newIndexMap.removeIndexProxy(indexId);
        this.setIndexMap(newIndexMap);
        return indexProxy;
    }

    public Iterable<IndexProxy> clear() {
        IndexMap oldIndexMap = this.indexMap;
        this.setIndexMap(new IndexMap());
        return oldIndexMap.getAllIndexProxies();
    }

    public IndexUpdaterMap getIndexUpdaterMap(IndexUpdateMode mode) {
        return new IndexUpdaterMap(mode, this.indexMap);
    }
}

