/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.storemigration;

import java.io.File;
import java.util.HashMap;
import org.neo4j.graphdb.factory.GraphDatabaseSettings;
import org.neo4j.kernel.DefaultTxHook;
import org.neo4j.kernel.IdGeneratorFactory;
import org.neo4j.kernel.configuration.Config;
import org.neo4j.kernel.impl.nioneo.store.CommonAbstractStore;
import org.neo4j.kernel.impl.nioneo.store.DefaultWindowPoolFactory;
import org.neo4j.kernel.impl.nioneo.store.FileSystemAbstraction;
import org.neo4j.kernel.impl.nioneo.store.NodeStore;
import org.neo4j.kernel.impl.nioneo.store.RelationshipGroupStore;
import org.neo4j.kernel.impl.nioneo.store.RelationshipStore;
import org.neo4j.kernel.impl.nioneo.store.StoreFactory;
import org.neo4j.kernel.impl.util.StringLogger;

public class IndividualNeoStores {
    private final File storageFileName;
    private final Config config;
    private final StoreFactory storeFactory;
    private NodeStore nodeStore;
    private RelationshipStore relationshipStore;
    private RelationshipGroupStore relationshipGroupStore;

    public IndividualNeoStores(FileSystemAbstraction fileSystem, File storageFileName, Config config, IdGeneratorFactory idGeneratorFactory) {
        this.storageFileName = storageFileName;
        this.config = this.patchedConfig(config);
        this.storeFactory = new StoreFactory(this.config, idGeneratorFactory, new DefaultWindowPoolFactory(), fileSystem, StringLogger.DEV_NULL, new DefaultTxHook());
    }

    private Config patchedConfig(Config config) {
        HashMap<String, String> map = new HashMap<String, String>(config.getParams());
        map.put("neo_store", this.storageFileName.getPath());
        return new Config(map);
    }

    private File storeFile(String part) {
        return new File(this.storageFileName.getParentFile(), this.storageFileName.getName() + part);
    }

    public File getNeoStoreFileName() {
        return this.storageFileName;
    }

    public File getNeoStoreDirectory() {
        return this.storageFileName.getParentFile();
    }

    public NodeStore createNodeStore() {
        File nodeStoreFileName = this.storeFile(".nodestore.db");
        this.storeFactory.createNodeStore(nodeStoreFileName);
        this.nodeStore = this.storeFactory.newNodeStore(nodeStoreFileName);
        return this.nodeStore;
    }

    public RelationshipStore createRelationshipStore() {
        File relStoreFileName = this.storeFile(".relationshipstore.db");
        this.storeFactory.createRelationshipStore(relStoreFileName);
        this.relationshipStore = this.storeFactory.newRelationshipStore(relStoreFileName);
        return this.relationshipStore;
    }

    public RelationshipGroupStore createRelationshipGroupStore() {
        File relGroupStoreFileName = this.storeFile(".relationshipgroupstore.db");
        this.storeFactory.createRelationshipGroupStore(relGroupStoreFileName, Integer.parseInt(GraphDatabaseSettings.dense_node_threshold.getDefaultValue()));
        this.relationshipGroupStore = this.storeFactory.newRelationshipGroupStore(relGroupStoreFileName);
        return this.relationshipGroupStore;
    }

    public void close() {
        this.nullSafeClose(this.nodeStore, this.relationshipStore, this.relationshipGroupStore);
    }

    private void nullSafeClose(CommonAbstractStore ... stores) {
        for (CommonAbstractStore store : stores) {
            if (store == null) continue;
            store.close();
        }
    }
}

