/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.ogm.jpa.impl;

import java.util.List;
import java.util.Map;
import javax.persistence.EntityExistsException;
import javax.persistence.EntityGraph;
import javax.persistence.EntityManager;
import javax.persistence.EntityManagerFactory;
import javax.persistence.EntityTransaction;
import javax.persistence.FlushModeType;
import javax.persistence.LockModeType;
import javax.persistence.PersistenceException;
import javax.persistence.StoredProcedureQuery;
import javax.persistence.Tuple;
import javax.persistence.TypedQuery;
import javax.persistence.criteria.CriteriaBuilder;
import javax.persistence.criteria.CriteriaDelete;
import javax.persistence.criteria.CriteriaQuery;
import javax.persistence.criteria.CriteriaUpdate;
import javax.persistence.metamodel.Metamodel;
import javax.transaction.SystemException;
import org.hibernate.AssertionFailure;
import org.hibernate.FlushMode;
import org.hibernate.HibernateException;
import org.hibernate.LockMode;
import org.hibernate.LockOptions;
import org.hibernate.Query;
import org.hibernate.SQLQuery;
import org.hibernate.Session;
import org.hibernate.SessionFactory;
import org.hibernate.boot.registry.classloading.spi.ClassLoaderService;
import org.hibernate.boot.registry.classloading.spi.ClassLoadingException;
import org.hibernate.engine.ResultSetMappingDefinition;
import org.hibernate.engine.query.spi.HQLQueryPlan;
import org.hibernate.engine.query.spi.sql.NativeSQLQueryConstructorReturn;
import org.hibernate.engine.query.spi.sql.NativeSQLQueryReturn;
import org.hibernate.engine.query.spi.sql.NativeSQLQueryRootReturn;
import org.hibernate.engine.query.spi.sql.NativeSQLQueryScalarReturn;
import org.hibernate.engine.spi.NamedQueryDefinition;
import org.hibernate.engine.spi.NamedSQLQueryDefinition;
import org.hibernate.engine.spi.SessionFactoryImplementor;
import org.hibernate.engine.spi.SessionImplementor;
import org.hibernate.engine.transaction.synchronization.spi.ExceptionMapper;
import org.hibernate.event.spi.EventSource;
import org.hibernate.jpa.HibernateEntityManagerFactory;
import org.hibernate.jpa.internal.QueryImpl;
import org.hibernate.jpa.internal.util.LockModeTypeHelper;
import org.hibernate.jpa.spi.AbstractEntityManagerImpl;
import org.hibernate.ogm.OgmSession;
import org.hibernate.ogm.OgmSessionFactory;
import org.hibernate.ogm.exception.EntityAlreadyExistsException;
import org.hibernate.ogm.exception.NotSupportedException;
import org.hibernate.ogm.hibernatecore.impl.OgmSessionFactoryImpl;
import org.hibernate.ogm.hibernatecore.impl.OgmSessionImpl;
import org.hibernate.ogm.jpa.impl.LetThroughExecuteUpdateQuery;
import org.hibernate.ogm.jpa.impl.OgmEntityManagerFactory;
import org.hibernate.ogm.jpa.impl.OgmJpaQuery;
import org.hibernate.transform.ResultTransformer;

public class OgmEntityManager
implements EntityManager {
    private final EntityManager hibernateEm;
    private final OgmEntityManagerFactory factory;
    private final LockOptions lockOptions = new LockOptions();

    public OgmEntityManager(OgmEntityManagerFactory factory, EntityManager hibernateEm) {
        this.hibernateEm = hibernateEm;
        this.factory = factory;
    }

    public void persist(Object entity) {
        this.hibernateEm.persist(entity);
    }

    public <T> T merge(T entity) {
        return (T)this.hibernateEm.merge(entity);
    }

    public void remove(Object entity) {
        this.hibernateEm.remove(entity);
    }

    public <T> T find(Class<T> entityClass, Object primaryKey) {
        return (T)this.hibernateEm.find(entityClass, primaryKey);
    }

    public <T> T find(Class<T> entityClass, Object primaryKey, Map<String, Object> properties) {
        return (T)this.hibernateEm.find(entityClass, primaryKey, properties);
    }

    public <T> T find(Class<T> entityClass, Object primaryKey, LockModeType lockMode) {
        return (T)this.hibernateEm.find(entityClass, primaryKey, lockMode);
    }

    public <T> T find(Class<T> entityClass, Object primaryKey, LockModeType lockMode, Map<String, Object> properties) {
        return (T)this.hibernateEm.find(entityClass, primaryKey, lockMode, properties);
    }

    public <T> T getReference(Class<T> entityClass, Object primaryKey) {
        return (T)this.hibernateEm.getReference(entityClass, primaryKey);
    }

    public void flush() {
        this.hibernateEm.flush();
    }

    public void setFlushMode(FlushModeType flushMode) {
        this.hibernateEm.setFlushMode(flushMode);
    }

    public FlushModeType getFlushMode() {
        return this.hibernateEm.getFlushMode();
    }

    public void lock(Object entity, LockModeType lockMode) {
        this.hibernateEm.lock(entity, lockMode);
    }

    public void lock(Object entity, LockModeType lockMode, Map<String, Object> properties) {
        this.hibernateEm.lock(entity, lockMode, properties);
    }

    public void refresh(Object entity) {
        this.hibernateEm.refresh(entity);
    }

    public void refresh(Object entity, Map<String, Object> properties) {
        this.hibernateEm.refresh(entity, properties);
    }

    public void refresh(Object entity, LockModeType lockMode) {
        this.hibernateEm.refresh(entity, lockMode);
    }

    public void refresh(Object entity, LockModeType lockMode, Map<String, Object> properties) {
        this.hibernateEm.refresh(entity, lockMode, properties);
    }

    public void clear() {
        this.hibernateEm.clear();
    }

    public void detach(Object entity) {
        this.hibernateEm.detach(entity);
    }

    public boolean contains(Object entity) {
        return this.hibernateEm.contains(entity);
    }

    public LockModeType getLockMode(Object entity) {
        return this.hibernateEm.getLockMode(entity);
    }

    public void setProperty(String propertyName, Object value) {
        this.hibernateEm.setProperty(propertyName, value);
    }

    public Map<String, Object> getProperties() {
        return this.hibernateEm.getProperties();
    }

    public javax.persistence.Query createQuery(String qlString) {
        if (qlString != null && qlString.toLowerCase().startsWith("delete from")) {
            return new LetThroughExecuteUpdateQuery();
        }
        Session session = (Session)this.getDelegate();
        return this.applyProperties((javax.persistence.Query)new OgmJpaQuery(session.createQuery(qlString), this.hibernateEm));
    }

    private javax.persistence.Query applyProperties(javax.persistence.Query query) {
        Object lockTimeout;
        Object queryTimeout;
        if (this.lockOptions.getLockMode() != LockMode.NONE) {
            query.setLockMode(this.getLockMode(this.lockOptions.getLockMode()));
        }
        if ((queryTimeout = this.getProperties().get("javax.persistence.query.timeout")) != null) {
            query.setHint("javax.persistence.query.timeout", queryTimeout);
        }
        if ((lockTimeout = this.getProperties().get("javax.persistence.lock.timeout")) != null) {
            query.setHint("javax.persistence.lock.timeout", lockTimeout);
        }
        return query;
    }

    public <T> TypedQuery<T> createQuery(CriteriaQuery<T> criteriaQuery) {
        throw new NotSupportedException("OGM-8", "criteria queries are not supported yet");
    }

    public javax.persistence.Query createQuery(CriteriaUpdate updateQuery) {
        throw new NotSupportedException("OGM-8", "criteria queries are not supported yet");
    }

    public javax.persistence.Query createQuery(CriteriaDelete deleteQuery) {
        throw new NotSupportedException("OGM-8", "criteria queries are not supported yet");
    }

    public <T> TypedQuery<T> createQuery(String qlString, Class<T> resultClass) {
        Session session = (Session)this.getDelegate();
        Query query = session.createQuery(qlString);
        this.resultClassChecking(resultClass, query);
        return new OgmJpaQuery(query, this.hibernateEm);
    }

    public javax.persistence.Query createNamedQuery(String name) {
        return this.buildQueryFromName(name, null);
    }

    private <T> TypedQuery<T> buildQueryFromName(String name, Class<T> resultType) {
        OgmSessionFactory sessionFactory = (OgmSessionFactory)this.factory.getSessionFactory();
        NamedSQLQueryDefinition queryDefinition = sessionFactory.getNamedSQLQuery(name);
        if (queryDefinition == null) {
            queryDefinition = sessionFactory.getNamedQuery(name);
            if (queryDefinition == null) {
                throw new IllegalArgumentException("Named query not found: " + name);
            }
            return this.createNamedJpqlQuery((NamedQueryDefinition)queryDefinition, resultType);
        }
        return this.createNamedNativeQuery(queryDefinition, resultType);
    }

    protected <T> TypedQuery<T> createNamedJpqlQuery(NamedQueryDefinition namedQueryDefinition, Class<T> resultType) {
        SessionImplementor session = (SessionImplementor)this.getDelegate();
        Query query = session.createQuery(namedQueryDefinition);
        if (resultType != null) {
            this.resultClassChecking(resultType, query);
        }
        return this.wrapAsJpaQuery(namedQueryDefinition, query);
    }

    protected <T> TypedQuery<T> wrapAsJpaQuery(NamedQueryDefinition namedQueryDefinition, Query hibQuery) {
        OgmJpaQuery jpaQuery = new OgmJpaQuery(hibQuery, this.hibernateEm);
        this.applySavedSettings(namedQueryDefinition, jpaQuery);
        return jpaQuery;
    }

    private <T> TypedQuery<T> createNamedNativeQuery(NamedSQLQueryDefinition sqlDefinition, Class<T> resultType) {
        if (resultType != null) {
            this.resultClassChecking(resultType, sqlDefinition);
        }
        String sqlQueryString = sqlDefinition.getQueryString();
        SQLQuery noSqlQuery = ((Session)this.getDelegate()).createSQLQuery(sqlQueryString);
        if (sqlDefinition.getQueryReturns() != null) {
            if (sqlDefinition.getQueryReturns().length == 1) {
                NativeSQLQueryRootReturn rootReturn = (NativeSQLQueryRootReturn)sqlDefinition.getQueryReturns()[0];
                noSqlQuery.addEntity("alias1", rootReturn.getReturnEntityName(), LockMode.READ);
            }
        } else if (sqlDefinition.getResultSetRef() != null) {
            SessionFactoryImplementor sessionFactory = (SessionFactoryImplementor)this.factory.getSessionFactory();
            ResultSetMappingDefinition resultSetMapping = sessionFactory.getResultSetMapping(sqlDefinition.getResultSetRef());
            if (resultSetMapping == null) {
                throw new HibernateException("Result set mapping '" + sqlDefinition.getResultSetRef() + "' referenced by query '" + sqlDefinition.getName() + "' does not exist.");
            }
            for (NativeSQLQueryReturn queryReturn : resultSetMapping.getQueryReturns()) {
                if (queryReturn instanceof NativeSQLQueryScalarReturn) {
                    noSqlQuery.addScalar(((NativeSQLQueryScalarReturn)queryReturn).getColumnAlias());
                    continue;
                }
                if (!(queryReturn instanceof NativeSQLQueryRootReturn)) continue;
                noSqlQuery.addEntity(((NativeSQLQueryRootReturn)queryReturn).getReturnEntityName());
            }
        }
        return new OgmJpaQuery((Query)noSqlQuery, this.hibernateEm);
    }

    protected void resultClassChecking(Class resultType, NamedSQLQueryDefinition namedQueryDefinition) {
        NativeSQLQueryConstructorReturn ctorRtn;
        NativeSQLQueryReturn[] queryReturns;
        SessionFactoryImplementor sfi = (SessionFactoryImplementor)this.factory.getSessionFactory();
        if (namedQueryDefinition.getQueryReturns() != null) {
            queryReturns = namedQueryDefinition.getQueryReturns();
        } else if (namedQueryDefinition.getResultSetRef() != null) {
            ResultSetMappingDefinition rsMapping = sfi.getResultSetMapping(namedQueryDefinition.getResultSetRef());
            queryReturns = rsMapping.getQueryReturns();
        } else {
            throw new AssertionFailure("Unsupported named query model. Please report the bug in Hibernate EntityManager");
        }
        if (queryReturns.length > 1) {
            throw new IllegalArgumentException("Cannot create TypedQuery for query with more than one return");
        }
        NativeSQLQueryReturn nativeSQLQueryReturn = queryReturns[0];
        if (nativeSQLQueryReturn instanceof NativeSQLQueryRootReturn) {
            Class actualReturnedClass;
            String entityClassName = ((NativeSQLQueryRootReturn)nativeSQLQueryReturn).getReturnEntityName();
            try {
                actualReturnedClass = ((ClassLoaderService)sfi.getServiceRegistry().getService(ClassLoaderService.class)).classForName(entityClassName);
            }
            catch (ClassLoadingException e) {
                throw new AssertionFailure("Unable to load class [" + entityClassName + "] declared on named native query [" + namedQueryDefinition.getName() + "]");
            }
            if (!resultType.isAssignableFrom(actualReturnedClass)) {
                throw this.buildIncompatibleException(resultType, actualReturnedClass);
            }
        } else if (nativeSQLQueryReturn instanceof NativeSQLQueryConstructorReturn && !resultType.isAssignableFrom((ctorRtn = (NativeSQLQueryConstructorReturn)nativeSQLQueryReturn).getTargetClass())) {
            throw this.buildIncompatibleException(resultType, ctorRtn.getTargetClass());
        }
    }

    private void resultClassChecking(Class resultClass, Query hqlQuery) {
        SessionImplementor session = this.unwrap(SessionImplementor.class);
        HQLQueryPlan queryPlan = session.getFactory().getQueryPlanCache().getHQLQueryPlan(hqlQuery.getQueryString(), false, session.getLoadQueryInfluencers().getEnabledFilters());
        if (queryPlan.getTranslators()[0].isManipulationStatement()) {
            throw new IllegalArgumentException("Update/delete queries cannot be typed");
        }
        if (!Object[].class.equals((Object)resultClass)) {
            if (Tuple.class.equals((Object)resultClass)) {
                AbstractEntityManagerImpl.TupleBuilderTransformer tupleTransformer = new AbstractEntityManagerImpl.TupleBuilderTransformer(hqlQuery);
                hqlQuery.setResultTransformer((ResultTransformer)tupleTransformer);
            } else {
                Class dynamicInstantiationClass = queryPlan.getDynamicInstantiationResultType();
                if (dynamicInstantiationClass != null) {
                    if (!resultClass.isAssignableFrom(dynamicInstantiationClass)) {
                        throw new IllegalArgumentException("Mismatch in requested result type [" + resultClass.getName() + "] and actual result type [" + dynamicInstantiationClass.getName() + "]");
                    }
                } else if (hqlQuery.getReturnTypes().length == 1) {
                    if (!resultClass.isAssignableFrom(hqlQuery.getReturnTypes()[0].getReturnedClass())) {
                        throw new IllegalArgumentException("Type specified for TypedQuery [" + resultClass.getName() + "] is incompatible with query return type [" + hqlQuery.getReturnTypes()[0].getReturnedClass() + "]");
                    }
                } else {
                    throw new IllegalArgumentException("Cannot create TypedQuery for query with more than one return using requested result type [" + resultClass.getName() + "]");
                }
            }
        }
    }

    private IllegalArgumentException buildIncompatibleException(Class<?> resultClass, Class<?> actualResultClass) {
        return new IllegalArgumentException("Type specified for TypedQuery [" + resultClass.getName() + "] is incompatible with query return type [" + actualResultClass + "]");
    }

    private void applySavedSettings(NamedQueryDefinition namedQueryDefinition, QueryImpl jpaQuery) {
        if (namedQueryDefinition.isCacheable()) {
            jpaQuery.setHint("org.hibernate.cacheable", (Object)true);
            if (namedQueryDefinition.getCacheRegion() != null) {
                jpaQuery.setHint("org.hibernate.cacheRegion", (Object)namedQueryDefinition.getCacheRegion());
            }
        }
        if (namedQueryDefinition.getCacheMode() != null) {
            jpaQuery.setHint("org.hibernate.cacheMode", (Object)namedQueryDefinition.getCacheMode());
        }
        if (namedQueryDefinition.isReadOnly()) {
            jpaQuery.setHint("org.hibernate.readOnly", (Object)true);
        }
        if (namedQueryDefinition.getTimeout() != null) {
            jpaQuery.setHint("javax.persistence.query.timeout", (Object)(namedQueryDefinition.getTimeout() * 1000));
        }
        if (namedQueryDefinition.getFetchSize() != null) {
            jpaQuery.setHint("org.hibernate.fetchSize", (Object)namedQueryDefinition.getFetchSize());
        }
        if (namedQueryDefinition.getComment() != null) {
            jpaQuery.setHint("org.hibernate.comment", (Object)namedQueryDefinition.getComment());
        }
        if (namedQueryDefinition.getFirstResult() != null) {
            jpaQuery.setFirstResult(namedQueryDefinition.getFirstResult().intValue());
        }
        if (namedQueryDefinition.getMaxResults() != null) {
            jpaQuery.setMaxResults(namedQueryDefinition.getMaxResults().intValue());
        }
        if (namedQueryDefinition.getLockOptions() != null && namedQueryDefinition.getLockOptions().getLockMode() != null) {
            jpaQuery.setLockMode(LockModeTypeHelper.getLockModeType((LockMode)namedQueryDefinition.getLockOptions().getLockMode()));
        }
        if (namedQueryDefinition.getFlushMode() != null) {
            if (namedQueryDefinition.getFlushMode() == FlushMode.COMMIT) {
                jpaQuery.setFlushMode(FlushModeType.COMMIT);
            } else {
                jpaQuery.setFlushMode(FlushModeType.AUTO);
            }
        }
    }

    public <T> TypedQuery<T> createNamedQuery(String name, Class<T> resultClass) {
        return this.buildQueryFromName(name, resultClass);
    }

    public javax.persistence.Query createNativeQuery(String sqlString) {
        SQLQuery q = ((Session)this.getDelegate()).createSQLQuery(sqlString);
        return new OgmJpaQuery((Query)q, this.hibernateEm);
    }

    public javax.persistence.Query createNativeQuery(String sqlString, Class resultClass) {
        SQLQuery q = ((Session)this.getDelegate()).createSQLQuery(sqlString);
        q.addEntity("alias1", resultClass.getName(), LockMode.READ);
        return new OgmJpaQuery((Query)q, this.hibernateEm);
    }

    public javax.persistence.Query createNativeQuery(String sqlString, String resultSetMapping) {
        SQLQuery q = ((Session)this.getDelegate()).createSQLQuery(sqlString);
        q.setResultSetMapping(resultSetMapping);
        return new OgmJpaQuery((Query)q, this.hibernateEm);
    }

    public StoredProcedureQuery createNamedStoredProcedureQuery(String name) {
        throw new NotSupportedException("OGM-359", "Stored procedures are not supported yet");
    }

    public StoredProcedureQuery createStoredProcedureQuery(String procedureName) {
        throw new NotSupportedException("OGM-359", "Stored procedures are not supported yet");
    }

    public StoredProcedureQuery createStoredProcedureQuery(String procedureName, Class ... resultClasses) {
        throw new NotSupportedException("OGM-359", "Stored procedures are not supported yet");
    }

    public StoredProcedureQuery createStoredProcedureQuery(String procedureName, String ... resultSetMappings) {
        throw new NotSupportedException("OGM-359", "Stored procedures are not supported yet");
    }

    public <T> EntityGraph<T> createEntityGraph(Class<T> rootType) {
        throw new IllegalStateException("Hibernate OGM does not support entity graphs");
    }

    public EntityGraph<?> createEntityGraph(String graphName) {
        throw new IllegalStateException("Hibernate OGM does not support entity graphs");
    }

    public EntityGraph<?> getEntityGraph(String graphName) {
        throw new IllegalStateException("Hibernate OGM does not support entity graphs");
    }

    public <T> List<EntityGraph<? super T>> getEntityGraphs(Class<T> entityClass) {
        throw new IllegalStateException("Hibernate OGM does not support entity graphs");
    }

    public void joinTransaction() {
        this.hibernateEm.joinTransaction();
        ((SessionImplementor)((AbstractEntityManagerImpl)this.hibernateEm).getSession()).getTransactionCoordinator().getSynchronizationCallbackCoordinator().setExceptionMapper((ExceptionMapper)new OgmExceptionMapper());
    }

    public boolean isJoinedToTransaction() {
        return this.hibernateEm.isJoinedToTransaction();
    }

    public <T> T unwrap(Class<T> cls) {
        Object session = this.hibernateEm.unwrap(cls);
        if (Session.class.isAssignableFrom(cls) || SessionImplementor.class.isAssignableFrom(cls)) {
            return (T)this.buildOgmSession((Session)((EventSource)session));
        }
        throw new HibernateException("Cannot unwrap the following type: " + cls);
    }

    private OgmSession buildOgmSession(Session session) {
        SessionFactory sessionFactory = ((HibernateEntityManagerFactory)this.hibernateEm.getEntityManagerFactory()).getSessionFactory();
        OgmSessionFactoryImpl ogmSessionFactory = new OgmSessionFactoryImpl((SessionFactoryImplementor)sessionFactory);
        return new OgmSessionImpl(ogmSessionFactory, (EventSource)session);
    }

    public Object getDelegate() {
        Object delegate = this.hibernateEm.getDelegate();
        if (Session.class.isAssignableFrom(delegate.getClass())) {
            return this.buildOgmSession((Session)((EventSource)delegate));
        }
        return delegate;
    }

    public void close() {
        this.hibernateEm.close();
    }

    public boolean isOpen() {
        return this.hibernateEm.isOpen();
    }

    public EntityTransaction getTransaction() {
        return this.hibernateEm.getTransaction();
    }

    public EntityManagerFactory getEntityManagerFactory() {
        return this.factory;
    }

    public CriteriaBuilder getCriteriaBuilder() {
        return this.hibernateEm.getCriteriaBuilder();
    }

    public Metamodel getMetamodel() {
        return this.hibernateEm.getMetamodel();
    }

    private final class OgmExceptionMapper
    implements ExceptionMapper {
        private OgmExceptionMapper() {
        }

        public RuntimeException mapStatusCheckFailure(String message, SystemException systemException) {
            throw new PersistenceException(message, (Throwable)systemException);
        }

        public RuntimeException mapManagedFlushFailure(String message, RuntimeException failure) {
            if (EntityAlreadyExistsException.class.isInstance(failure)) {
                throw new EntityExistsException((Throwable)failure);
            }
            if (HibernateException.class.isInstance(failure)) {
                throw ((AbstractEntityManagerImpl)OgmEntityManager.this.hibernateEm).convert(failure);
            }
            if (PersistenceException.class.isInstance(failure)) {
                throw failure;
            }
            throw new PersistenceException(message, (Throwable)failure);
        }
    }
}

