/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.ogm.transaction.impl;

import javax.transaction.SystemException;
import javax.transaction.UserTransaction;
import org.hibernate.ConnectionReleaseMode;
import org.hibernate.TransactionException;
import org.hibernate.engine.transaction.internal.jta.JtaStatusHelper;
import org.hibernate.engine.transaction.jta.platform.spi.JtaPlatform;
import org.hibernate.engine.transaction.spi.TransactionCoordinator;
import org.hibernate.engine.transaction.spi.TransactionFactory;
import org.hibernate.engine.transaction.spi.TransactionImplementor;
import org.hibernate.ogm.transaction.impl.JTATransactionManagerTransaction;

public class JTATransactionManagerTransactionFactory
implements TransactionFactory {
    public TransactionImplementor createTransaction(TransactionCoordinator coordinator) {
        return new JTATransactionManagerTransaction(coordinator);
    }

    public boolean canBeDriver() {
        return true;
    }

    public boolean compatibleWithJtaSynchronization() {
        return true;
    }

    public boolean isJoinableJtaTransaction(TransactionCoordinator transactionCoordinator, TransactionImplementor transaction) {
        try {
            JtaPlatform jtaPlatform = transactionCoordinator.getTransactionContext().getTransactionEnvironment().getJtaPlatform();
            if (jtaPlatform == null) {
                throw new TransactionException("Unable to check transaction status");
            }
            if (jtaPlatform.retrieveTransactionManager() != null) {
                return JtaStatusHelper.isActive((int)jtaPlatform.retrieveTransactionManager().getStatus());
            }
            UserTransaction ut = jtaPlatform.retrieveUserTransaction();
            return ut != null && JtaStatusHelper.isActive((UserTransaction)ut);
        }
        catch (SystemException se) {
            throw new TransactionException("Unable to check transaction status", (Throwable)se);
        }
    }

    public ConnectionReleaseMode getDefaultReleaseMode() {
        return ConnectionReleaseMode.AFTER_STATEMENT;
    }
}

