/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.ogm.datastore.mongodb.type.impl;

import org.bson.types.ObjectId;
import org.hibernate.type.descriptor.WrapperOptions;
import org.hibernate.type.descriptor.java.AbstractTypeDescriptor;

public class StringAsObjectIdTypeDescriptor
extends AbstractTypeDescriptor<String> {
    public static final StringAsObjectIdTypeDescriptor INSTANCE = new StringAsObjectIdTypeDescriptor();

    public StringAsObjectIdTypeDescriptor() {
        super(String.class);
    }

    public String toString(String value) {
        return value == null ? null : value;
    }

    public String fromString(String string) {
        return string;
    }

    public <X> X unwrap(String value, Class<X> type, WrapperOptions options) {
        if (value == null) {
            return null;
        }
        return (X)new ObjectId(value);
    }

    public <X> String wrap(X value, WrapperOptions options) {
        if (value == null) {
            return null;
        }
        if (ObjectId.class.isInstance(value)) {
            return ((ObjectId)value).toString();
        }
        throw this.unknownWrap(value.getClass());
    }
}

