/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.ogm.jpa;

import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.persistence.EntityManagerFactory;
import javax.persistence.PersistenceException;
import javax.persistence.spi.PersistenceProvider;
import javax.persistence.spi.PersistenceUnitInfo;
import javax.persistence.spi.ProviderUtil;
import org.hibernate.jpa.HibernatePersistenceProvider;
import org.hibernate.jpa.boot.internal.ParsedPersistenceXmlDescriptor;
import org.hibernate.jpa.boot.internal.PersistenceXmlParser;
import org.hibernate.ogm.cfg.impl.HibernateSearchIntegration;
import org.hibernate.ogm.cfg.impl.OgmNamingStrategy;
import org.hibernate.ogm.jpa.impl.DelegatorPersistenceUnitInfo;
import org.hibernate.ogm.jpa.impl.OgmEntityManagerFactory;
import org.hibernate.ogm.jpa.impl.OgmIdentifierGeneratorStrategyProvider;
import org.hibernate.ogm.query.impl.OgmQueryTranslatorFactory;

public class HibernateOgmPersistence
implements PersistenceProvider {
    private static String IMPLEMENTATION_NAME = HibernateOgmPersistence.class.getName();
    private final HibernatePersistenceProvider delegate = new HibernatePersistenceProvider();

    public EntityManagerFactory createEntityManagerFactory(String emName, Map map) {
        try {
            Map integration = map == null ? Collections.emptyMap() : Collections.unmodifiableMap(map);
            List metadataFiles = PersistenceXmlParser.locatePersistenceUnits(integration);
            for (ParsedPersistenceXmlDescriptor metadata : metadataFiles) {
                if (!IMPLEMENTATION_NAME.equalsIgnoreCase(metadata.getProviderClassName())) continue;
                HashMap<Object, Object> protectiveCopy = new HashMap<Object, Object>(integration);
                this.enforceOgmConfig(protectiveCopy);
                protectiveCopy.put("javax.persistence.provider", this.delegate.getClass().getName());
                EntityManagerFactory coreEMF = this.delegate.createEntityManagerFactory(emName, protectiveCopy);
                if (coreEMF == null) continue;
                return new OgmEntityManagerFactory(coreEMF);
            }
            return null;
        }
        catch (PersistenceException pe) {
            throw pe;
        }
        catch (Exception e) {
            throw new PersistenceException("Unable to build EntityManagerFactory", (Throwable)e);
        }
    }

    private void enforceOgmConfig(Map<Object, Object> map) {
        map.put("hibernate.ejb.naming_strategy", OgmNamingStrategy.class.getName());
        map.put("hibernate.connection.datasource", "---PlaceHolderDSForOGM---");
        map.put("hibernate.ejb.identifier_generator_strategy_provider", OgmIdentifierGeneratorStrategyProvider.class.getName());
        map.put("hibernate.id.new_generator_mappings", "true");
        map.put("hibernate.ogm._activate", "true");
        map.put("hibernate.query.factory_class", OgmQueryTranslatorFactory.class.getName());
        HibernateSearchIntegration.resetProperties(map);
    }

    public EntityManagerFactory createContainerEntityManagerFactory(PersistenceUnitInfo info, Map map) {
        String persistenceProviderClassName = info.getPersistenceProviderClassName();
        if (persistenceProviderClassName == null || IMPLEMENTATION_NAME.equals(persistenceProviderClassName)) {
            HashMap<Object, Object> protectiveCopy = map != null ? new HashMap<Object, Object>(map) : new HashMap();
            this.enforceOgmConfig(protectiveCopy);
            EntityManagerFactory coreEMF = this.delegate.createContainerEntityManagerFactory((PersistenceUnitInfo)new DelegatorPersistenceUnitInfo(info), protectiveCopy);
            if (coreEMF != null) {
                return new OgmEntityManagerFactory(coreEMF);
            }
        }
        return null;
    }

    public ProviderUtil getProviderUtil() {
        return this.delegate.getProviderUtil();
    }

    public void generateSchema(PersistenceUnitInfo info, Map map) {
        throw new IllegalStateException("Hibernate OGM does not support schema generation");
    }

    public boolean generateSchema(String persistenceUnitName, Map map) {
        throw new IllegalStateException("Hibernate OGM does not support schema generation");
    }
}

