/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.ogm.service.impl;

import java.lang.reflect.Field;
import java.util.Map;
import org.hibernate.SessionFactoryObserver;
import org.hibernate.boot.registry.StandardServiceInitiator;
import org.hibernate.boot.registry.StandardServiceRegistryBuilder;
import org.hibernate.cfg.Configuration;
import org.hibernate.engine.config.internal.ConfigurationServiceInitiator;
import org.hibernate.engine.spi.SessionFactoryImplementor;
import org.hibernate.event.service.spi.DuplicationStrategy;
import org.hibernate.event.service.spi.EventListenerRegistry;
import org.hibernate.event.spi.EventType;
import org.hibernate.integrator.spi.Integrator;
import org.hibernate.integrator.spi.IntegratorService;
import org.hibernate.integrator.spi.ServiceContributingIntegrator;
import org.hibernate.jpa.event.spi.JpaIntegrator;
import org.hibernate.jpa.event.spi.jpa.CallbackRegistry;
import org.hibernate.metamodel.source.MetadataImplementor;
import org.hibernate.ogm.cfg.impl.Version;
import org.hibernate.ogm.datastore.impl.DatastoreProviderInitiator;
import org.hibernate.ogm.dialect.impl.BatchOperationsDelegator;
import org.hibernate.ogm.dialect.impl.ForwardingGridDialect;
import org.hibernate.ogm.dialect.impl.GridDialectInitiator;
import org.hibernate.ogm.dialect.impl.IdentityColumnAwareGridDialectInitiator;
import org.hibernate.ogm.dialect.impl.OgmDialectFactoryInitiator;
import org.hibernate.ogm.dialect.impl.OptimisticLockingAwareGridDialectInitiator;
import org.hibernate.ogm.dialect.impl.QueryableGridDialectInitiator;
import org.hibernate.ogm.dialect.impl.SessionFactoryLifecycleAwareDialectInitializer;
import org.hibernate.ogm.dialect.spi.GridDialect;
import org.hibernate.ogm.jdbc.impl.OgmConnectionProviderInitiator;
import org.hibernate.ogm.jpa.impl.OgmPersisterClassResolverInitiator;
import org.hibernate.ogm.options.navigation.impl.OptionsServiceInitiator;
import org.hibernate.ogm.service.impl.AutoFlushBatchManagerEventListener;
import org.hibernate.ogm.service.impl.FlushBatchManagerEventListener;
import org.hibernate.ogm.service.impl.OgmJdbcServicesInitiator;
import org.hibernate.ogm.service.impl.OgmSessionFactoryServiceRegistryFactoryInitiator;
import org.hibernate.ogm.service.impl.SchemaDefiningObserver;
import org.hibernate.ogm.service.listener.impl.OgmDefaultMergeEventListener;
import org.hibernate.ogm.service.listener.impl.OgmDefaultPersistEventListener;
import org.hibernate.ogm.service.listener.impl.OgmDefaultPersistOnFlushEventListener;
import org.hibernate.ogm.service.listener.impl.OgmDefaultReplicateEventListener;
import org.hibernate.ogm.service.listener.impl.OgmDefaultSaveEventListener;
import org.hibernate.ogm.service.listener.impl.OgmDefaultSaveOrUpdateEventListener;
import org.hibernate.ogm.service.listener.impl.OgmDefaultUpdateEventListener;
import org.hibernate.ogm.service.listener.impl.OgmJpaMergeEventListener;
import org.hibernate.ogm.service.listener.impl.OgmJpaPersistEventListener;
import org.hibernate.ogm.service.listener.impl.OgmJpaPersistOnFlushEventListener;
import org.hibernate.ogm.service.listener.impl.OgmJpaSaveEventListener;
import org.hibernate.ogm.service.listener.impl.OgmJpaSaveOrUpdateEventListener;
import org.hibernate.ogm.service.listener.impl.OgmPersistEventDuplicationStrategy;
import org.hibernate.ogm.transaction.impl.OgmJtaPlatformInitiator;
import org.hibernate.ogm.transaction.impl.OgmTransactionFactoryInitiator;
import org.hibernate.ogm.type.impl.TypeTranslatorInitiator;
import org.hibernate.ogm.util.configurationreader.spi.ConfigurationPropertyReader;
import org.hibernate.service.spi.SessionFactoryServiceRegistry;

public class OgmIntegrator
implements Integrator,
ServiceContributingIntegrator {
    public void integrate(Configuration configuration, SessionFactoryImplementor sessionFactory, SessionFactoryServiceRegistry serviceRegistry) {
        this.doIntegrate(configuration, sessionFactory, serviceRegistry);
    }

    public void integrate(MetadataImplementor metadata, SessionFactoryImplementor sessionFactory, SessionFactoryServiceRegistry serviceRegistry) {
        this.doIntegrate(null, sessionFactory, serviceRegistry);
    }

    public void disintegrate(SessionFactoryImplementor sessionFactory, SessionFactoryServiceRegistry serviceRegistry) {
    }

    public void prepareServices(StandardServiceRegistryBuilder serviceRegistryBuilder) {
        if (!this.isOgmUsed(serviceRegistryBuilder.getSettings())) {
            return;
        }
        serviceRegistryBuilder.addInitiator((StandardServiceInitiator)OgmSessionFactoryServiceRegistryFactoryInitiator.INSTANCE);
        serviceRegistryBuilder.addInitiator((StandardServiceInitiator)ConfigurationServiceInitiator.INSTANCE);
        serviceRegistryBuilder.addInitiator((StandardServiceInitiator)OgmPersisterClassResolverInitiator.INSTANCE);
        serviceRegistryBuilder.addInitiator((StandardServiceInitiator)OgmConnectionProviderInitiator.INSTANCE);
        serviceRegistryBuilder.addInitiator((StandardServiceInitiator)OgmDialectFactoryInitiator.INSTANCE);
        serviceRegistryBuilder.addInitiator((StandardServiceInitiator)OgmTransactionFactoryInitiator.INSTANCE);
        serviceRegistryBuilder.addInitiator((StandardServiceInitiator)OgmJtaPlatformInitiator.INSTANCE);
        serviceRegistryBuilder.addInitiator((StandardServiceInitiator)OgmJdbcServicesInitiator.INSTANCE);
        serviceRegistryBuilder.addInitiator((StandardServiceInitiator)DatastoreProviderInitiator.INSTANCE);
        serviceRegistryBuilder.addInitiator((StandardServiceInitiator)OptionsServiceInitiator.INSTANCE);
        serviceRegistryBuilder.addInitiator((StandardServiceInitiator)TypeTranslatorInitiator.INSTANCE);
        serviceRegistryBuilder.addInitiator((StandardServiceInitiator)GridDialectInitiator.INSTANCE);
        serviceRegistryBuilder.addInitiator((StandardServiceInitiator)QueryableGridDialectInitiator.INSTANCE);
        serviceRegistryBuilder.addInitiator((StandardServiceInitiator)IdentityColumnAwareGridDialectInitiator.INSTANCE);
        serviceRegistryBuilder.addInitiator((StandardServiceInitiator)OptimisticLockingAwareGridDialectInitiator.INSTANCE);
    }

    private void doIntegrate(Configuration configuration, SessionFactoryImplementor sessionFactory, SessionFactoryServiceRegistry serviceRegistry) {
        if (!this.isOgmUsed(configuration.getProperties())) {
            return;
        }
        Version.touch();
        sessionFactory.addObserver((SessionFactoryObserver)new SchemaDefiningObserver(configuration));
        sessionFactory.addObserver((SessionFactoryObserver)new SessionFactoryLifecycleAwareDialectInitializer());
        this.attachBatchListenersIfRequired(serviceRegistry);
        this.attachPersistListener(serviceRegistry);
    }

    private boolean isOgmUsed(Map properties) {
        return new ConfigurationPropertyReader(properties).property("hibernate.ogm._activate", Boolean.TYPE).withDefault(false).getValue();
    }

    private void attachBatchListenersIfRequired(SessionFactoryServiceRegistry serviceRegistry) {
        GridDialect gridDialect = (GridDialect)serviceRegistry.getService(GridDialect.class);
        BatchOperationsDelegator batchDelegator = this.asBatchDelegatorOrNull(gridDialect);
        if (batchDelegator != null) {
            EventListenerRegistry eventListenerRegistry = (EventListenerRegistry)serviceRegistry.getService(EventListenerRegistry.class);
            this.addListeners(eventListenerRegistry, batchDelegator);
        }
    }

    private void attachPersistListener(SessionFactoryServiceRegistry serviceRegistry) {
        EventListenerRegistry eventListenerRegistry = (EventListenerRegistry)serviceRegistry.getService(EventListenerRegistry.class);
        JpaIntegrator integrator = this.getIntegrator(JpaIntegrator.class, serviceRegistry);
        CallbackRegistry callbackRegistry = integrator != null ? this.extractCallbackRegistry(integrator) : null;
        eventListenerRegistry.addDuplicationStrategy((DuplicationStrategy)new OgmPersistEventDuplicationStrategy(callbackRegistry));
        eventListenerRegistry.getEventListenerGroup(EventType.MERGE).appendListener((Object)new OgmDefaultMergeEventListener());
        eventListenerRegistry.getEventListenerGroup(EventType.PERSIST).appendListener((Object)new OgmDefaultPersistEventListener());
        eventListenerRegistry.getEventListenerGroup(EventType.PERSIST_ONFLUSH).appendListener((Object)new OgmDefaultPersistOnFlushEventListener());
        eventListenerRegistry.getEventListenerGroup(EventType.REPLICATE).appendListener((Object)new OgmDefaultReplicateEventListener());
        eventListenerRegistry.getEventListenerGroup(EventType.SAVE).appendListener((Object)new OgmDefaultSaveEventListener());
        eventListenerRegistry.getEventListenerGroup(EventType.SAVE_UPDATE).appendListener((Object)new OgmDefaultSaveOrUpdateEventListener());
        eventListenerRegistry.getEventListenerGroup(EventType.UPDATE).appendListener((Object)new OgmDefaultUpdateEventListener());
        eventListenerRegistry.getEventListenerGroup(EventType.MERGE).appendListener((Object)new OgmJpaMergeEventListener());
        eventListenerRegistry.getEventListenerGroup(EventType.PERSIST).appendListener((Object)new OgmJpaPersistEventListener());
        eventListenerRegistry.getEventListenerGroup(EventType.PERSIST_ONFLUSH).appendListener((Object)new OgmJpaPersistOnFlushEventListener());
        eventListenerRegistry.getEventListenerGroup(EventType.SAVE).appendListener((Object)new OgmJpaSaveEventListener());
        eventListenerRegistry.getEventListenerGroup(EventType.SAVE_UPDATE).appendListener((Object)new OgmJpaSaveOrUpdateEventListener());
    }

    private <T extends Integrator> T getIntegrator(Class<T> integratorType, SessionFactoryServiceRegistry serviceRegistry) {
        Iterable integrators = ((IntegratorService)serviceRegistry.getService(IntegratorService.class)).getIntegrators();
        for (Integrator integrator : integrators) {
            if (!integratorType.isInstance(integrator)) continue;
            return (T)integrator;
        }
        return null;
    }

    private CallbackRegistry extractCallbackRegistry(JpaIntegrator integrator) {
        try {
            Field registryField = JpaIntegrator.class.getDeclaredField("callbackRegistry");
            registryField.setAccessible(true);
            return (CallbackRegistry)registryField.get(integrator);
        }
        catch (Exception e) {
            throw new RuntimeException("Can't extract callback registry", e);
        }
    }

    private BatchOperationsDelegator asBatchDelegatorOrNull(GridDialect gridDialect) {
        while (gridDialect instanceof ForwardingGridDialect) {
            if (gridDialect instanceof BatchOperationsDelegator) {
                return (BatchOperationsDelegator)gridDialect;
            }
            gridDialect = ((ForwardingGridDialect)gridDialect).getGridDialect();
        }
        return null;
    }

    private void addListeners(EventListenerRegistry eventListenerRegistry, BatchOperationsDelegator gridDialect) {
        eventListenerRegistry.addDuplicationStrategy((DuplicationStrategy)new FlushBatchManagerEventListener.FlushDuplicationStrategy());
        eventListenerRegistry.addDuplicationStrategy((DuplicationStrategy)new AutoFlushBatchManagerEventListener.AutoFlushDuplicationStrategy());
        eventListenerRegistry.getEventListenerGroup(EventType.FLUSH).appendListener((Object)new FlushBatchManagerEventListener(gridDialect));
        eventListenerRegistry.getEventListenerGroup(EventType.AUTO_FLUSH).appendListener((Object)new AutoFlushBatchManagerEventListener(gridDialect));
    }
}

