/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.ogm.service.impl;

import org.hibernate.SessionFactory;
import org.hibernate.SessionFactoryObserver;
import org.hibernate.cfg.Configuration;
import org.hibernate.engine.spi.SessionFactoryImplementor;
import org.hibernate.ogm.datastore.spi.SchemaDefiner;
import org.hibernate.service.spi.ServiceRegistryImplementor;

public class SchemaDefiningObserver
implements SessionFactoryObserver {
    private final Configuration configuration;

    public SchemaDefiningObserver(Configuration configuration) {
        this.configuration = configuration;
    }

    public void sessionFactoryCreated(SessionFactory factory) {
        SessionFactoryImplementor sessionFactoryImplementor = (SessionFactoryImplementor)factory;
        ServiceRegistryImplementor registry = sessionFactoryImplementor.getServiceRegistry();
        SchemaDefiner schemaInitializer = (SchemaDefiner)registry.getService(SchemaDefiner.class);
        schemaInitializer.validateMapping(sessionFactoryImplementor);
        schemaInitializer.initializeSchema(this.configuration, sessionFactoryImplementor);
    }

    public void sessionFactoryClosed(SessionFactory factory) {
    }
}

