/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.ogm.transaction.impl;

import java.util.Map;
import org.hibernate.boot.registry.StandardServiceInitiator;
import org.hibernate.engine.transaction.internal.TransactionFactoryInitiator;
import org.hibernate.engine.transaction.internal.jdbc.JdbcTransactionFactory;
import org.hibernate.engine.transaction.spi.TransactionFactory;
import org.hibernate.ogm.datastore.spi.DatastoreProvider;
import org.hibernate.ogm.transaction.impl.OgmTransactionFactory;
import org.hibernate.ogm.util.impl.Log;
import org.hibernate.ogm.util.impl.LoggerFactory;
import org.hibernate.service.spi.ServiceRegistryImplementor;

public class OgmTransactionFactoryInitiator
implements StandardServiceInitiator<TransactionFactory> {
    public static final OgmTransactionFactoryInitiator INSTANCE = new OgmTransactionFactoryInitiator();
    private static final Log log = LoggerFactory.make();

    public Class<TransactionFactory> getServiceInitiated() {
        return TransactionFactory.class;
    }

    public TransactionFactory<?> initiateService(Map configurationValues, ServiceRegistryImplementor registry) {
        boolean emulateTransactions;
        if (this.hasExplicitNonJPAResourceLocalTransactionFactory(configurationValues)) {
            return TransactionFactoryInitiator.INSTANCE.initiateService(configurationValues, registry);
        }
        DatastoreProvider datastoreProvider = (DatastoreProvider)registry.getService(DatastoreProvider.class);
        if (datastoreProvider.allowsTransactionEmulation()) {
            emulateTransactions = true;
        } else {
            log.usingDefaultTransactionFactory();
            emulateTransactions = false;
        }
        return new OgmTransactionFactory(emulateTransactions);
    }

    private boolean hasExplicitNonJPAResourceLocalTransactionFactory(Map configurationValues) {
        Object strategy = configurationValues.get("hibernate.transaction.factory_class");
        return strategy != null && !this.isResourceLocalTransactionType(strategy);
    }

    private boolean isResourceLocalTransactionType(Object strategy) {
        return JdbcTransactionFactory.class.getName().equals(strategy) || JdbcTransactionFactory.class.equals(strategy);
    }
}

