/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.ogm.datastore.infinispan.persistencestrategy.table.externalizer.impl;

import org.hibernate.ogm.model.key.spi.IdSourceKey;

public class PersistentIdSourceKey {
    private final String name;
    private final Object value;

    public PersistentIdSourceKey(String name, Object value) {
        this.name = name;
        this.value = value;
    }

    public static PersistentIdSourceKey fromIdSourceKey(IdSourceKey key) {
        return new PersistentIdSourceKey(key.getColumnNames()[0], key.getColumnValues()[0]);
    }

    public String getName() {
        return this.name;
    }

    public Object getValue() {
        return this.value;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.name == null ? 0 : this.name.hashCode());
        result = 31 * result + (this.value == null ? 0 : this.value.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        PersistentIdSourceKey other = (PersistentIdSourceKey)obj;
        if (this.name == null ? other.name != null : !this.name.equals(other.name)) {
            return false;
        }
        return !(this.value == null ? other.value != null : !this.value.equals(other.value));
    }

    public String toString() {
        return "PersistentIdSourceKey [name=" + this.name + ", value=" + this.value + "]";
    }
}

