/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.resteasy.skeleton.key.jaxrs;

import java.net.URI;
import javax.ws.rs.BadRequestException;
import javax.ws.rs.InternalServerErrorException;
import javax.ws.rs.core.Cookie;
import javax.ws.rs.core.HttpHeaders;
import javax.ws.rs.core.NewCookie;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriBuilder;
import javax.ws.rs.core.UriInfo;
import org.jboss.resteasy.skeleton.key.AbstractOAuthClient;

public class JaxrsOAuthClient
extends AbstractOAuthClient {
    public Response redirect(UriInfo uriInfo, String redirectUri) {
        String state = this.getStateCode();
        URI url = UriBuilder.fromUri((String)this.authUrl).queryParam("client_id", new Object[]{this.clientId}).queryParam("redirect_uri", new Object[]{redirectUri}).queryParam("state", new Object[]{state}).build(new Object[0]);
        NewCookie cookie = new NewCookie(this.stateCookieName, state, uriInfo.getBaseUri().getPath(), null, null, -1, true);
        return Response.status((int)302).location(url).cookie(new NewCookie[]{cookie}).build();
    }

    public String getBearerToken(UriInfo uriInfo, HttpHeaders headers) throws BadRequestException, InternalServerErrorException {
        String error = (String)uriInfo.getQueryParameters().getFirst((Object)"error");
        if (error != null) {
            throw new BadRequestException((Throwable)new Exception("OAuth error: " + error));
        }
        Cookie stateCookie = (Cookie)headers.getCookies().get(this.stateCookieName);
        if (stateCookie == null) {
            throw new BadRequestException((Throwable)new Exception("state cookie not set"));
        }
        String state = (String)uriInfo.getQueryParameters().getFirst((Object)"state");
        if (state == null) {
            throw new BadRequestException((Throwable)new Exception("state parameter was null"));
        }
        if (!state.equals(stateCookie.getValue())) {
            throw new BadRequestException((Throwable)new Exception("state parameter invalid"));
        }
        String code = (String)uriInfo.getQueryParameters().getFirst((Object)"code");
        if (code == null) {
            throw new BadRequestException((Throwable)new Exception("code parameter was null"));
        }
        return this.resolveBearerToken(uriInfo.getRequestUri().toString(), code);
    }
}

