/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.api.impl.index;

import java.io.IOException;
import org.apache.lucene.search.BooleanClause;
import org.apache.lucene.search.BooleanQuery;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.SearcherManager;
import org.apache.lucene.search.TermQuery;
import org.neo4j.collection.primitive.PrimitiveLongIterator;
import org.neo4j.index.impl.lucene.Hits;
import org.neo4j.kernel.api.impl.index.HitsPrimitiveLongIterator;
import org.neo4j.kernel.api.impl.index.LuceneDocumentStructure;
import org.neo4j.kernel.api.index.IndexReader;

class LuceneIndexAccessorReader
implements IndexReader {
    private final IndexSearcher searcher;
    private final LuceneDocumentStructure documentLogic;
    private final SearcherManager searcherManager;

    LuceneIndexAccessorReader(SearcherManager searcherManager, LuceneDocumentStructure documentLogic) {
        this.searcherManager = searcherManager;
        this.searcher = (IndexSearcher)searcherManager.acquire();
        this.documentLogic = documentLogic;
    }

    public PrimitiveLongIterator lookup(Object value) {
        try {
            Hits hits = new Hits(this.searcher, this.documentLogic.newQuery(value), null);
            return new HitsPrimitiveLongIterator(hits, this.documentLogic);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public int getIndexedCount(long nodeId, Object propertyValue) {
        TermQuery nodeIdQuery = new TermQuery(this.documentLogic.newQueryForChangeOrRemove(nodeId));
        Query valueQuery = this.documentLogic.newQuery(propertyValue);
        BooleanQuery nodeIdAndValueQuery = new BooleanQuery(true);
        nodeIdAndValueQuery.add((Query)nodeIdQuery, BooleanClause.Occur.MUST);
        nodeIdAndValueQuery.add(valueQuery, BooleanClause.Occur.MUST);
        try {
            Hits hits = new Hits(this.searcher, (Query)nodeIdAndValueQuery, null);
            return hits.length();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public void close() {
        try {
            this.searcherManager.release((Object)this.searcher);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }
}

